package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;

import static com.bxm.localnews.news.constant.LogicGroupConstant.TOPIC_FILL_FILTER;

/**
 * 填充二级话题信息
 *
 * @author liujia
 * @date 1/21/21 7:02 PM
 **/
@FilterBean(group = TOPIC_FILL_FILTER)
@AllArgsConstructor
public class TopicSecondInfoFilter implements IFilter<TopicContext> {

    private ForumTopicMapper forumTopicMapper;

    @Override
    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();
        topicVo.setTopicSecondInfoList(forumTopicMapper.getTopicSecondTitle(topicVo.getId()));
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
