package com.bxm.localnews.news.topic.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.domain.AdminAreaRelationMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.domain.AdminMixedRecommendPoolMapper;
import com.bxm.localnews.news.domain.AdminTopicMapper;
import com.bxm.localnews.news.enums.AreaRelationTypeEnum;
import com.bxm.localnews.news.model.dto.AdminAreaRelationDTO;
import com.bxm.localnews.news.model.param.AdminTopicParam;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.topic.AdminTopicService;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Service
public class AdminTopicServiceImpl implements AdminTopicService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private AdminTopicMapper adminTopicMapper;

    @Resource
    private AdminForumPostMapper adminForumPostMapper;

    @Resource
    private AdminAreaRelationMapper adminAreaRelationMapper;

    @Resource
    private LocationIntegrationService locationService;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private ForumTopicService forumTopicService;

    @Resource
    private ForumPostService forumPostService;

    @Override
    public PageWarper<AdminTopic> getList(AdminTopicParam param) {
        PageWarper<AdminTopic> topicList = new PageWarper<>(adminTopicMapper.getList(param));

        if (CollectionUtils.isNotEmpty(topicList.getList())) {
            for (AdminTopic adminTopic : topicList.getList()) {
                completeTopic(adminTopic);
            }
        }

        return topicList;
    }

    @Override
    public AdminTopic selectByPrimaryKey(Long id) {
        AdminTopic adminTopic = adminTopicMapper.selectByPrimaryKey(id);
        completeTopic(adminTopic);
        return adminTopic;
    }

    @Override
    public int updateStatus(Long id, Byte status) {
        AdminTopic adminTopic = this.adminTopicMapper.selectByPrimaryKey(id);
        if (adminTopic == null) {
            return 0;
        }
        adminTopic.setEnable(status);
        this.adminTopicMapper.updateByPrimaryKeySelective(adminTopic);

        forumTopicService.removeCache(id);

        if ((byte) 2 == status) {
            List<Long> postIdList = this.adminTopicMapper.listPostIdByTopicId(id);

            MybatisBatchBuilder.create(AdminMixedRecommendPoolMapper.class, postIdList).run(AdminMixedRecommendPoolMapper::deleteByPrimaryKey);
            this.adminTopicMapper.deletePostsByTopicId(id);
        }

        return 1;
    }

    @Override
    public int saveOrUpdate(AdminTopic adminTopic) {
        int update;
        Long topicId = adminTopic.getId();

        if (null == topicId) {
            topicId = sequenceCreater.nextLongId();
            adminTopic.setId(topicId);
            adminTopic.setCreateTime(new Date());
            update = this.adminTopicMapper.insert(adminTopic);
        } else {
            update = this.adminTopicMapper.updateByPrimaryKeySelective(adminTopic);
            List<Long> postIdList = adminTopicMapper.listPostIdByTopicId(topicId);
            if (CollectionUtils.isNotEmpty(postIdList)) {
                adminForumPostMapper.updateForumContentByIdList(postIdList, adminTopic.getContent());
            }
        }

        adminAreaRelationMapper.batchDelete(adminTopic.getId(), AreaRelationTypeEnum.TOPIC.getType());

        if (CollectionUtils.isNotEmpty(adminTopic.getAreaCodes())) {
            List<AdminAreaRelationDTO> list = new ArrayList<>();
            for (String areaCode : adminTopic.getAreaCodes()) {
                AdminAreaRelationDTO adminAreaRelationDTO = new AdminAreaRelationDTO();
                adminAreaRelationDTO.setId(sequenceCreater.nextLongId());
                adminAreaRelationDTO.setRelationId(adminTopic.getId());
                adminAreaRelationDTO.setAreaCode(areaCode);
                adminAreaRelationDTO.setType((byte) 2);
                list.add(adminAreaRelationDTO);
            }
            adminAreaRelationMapper.batchInsert(list);
        }

        forumTopicService.removeCache(topicId);

        return update;
    }

    @Override
    public int updateOrder(Long id, Integer order) {
        AdminTopic adminTopic = this.adminTopicMapper.selectByPrimaryKey(id);
        if (adminTopic == null) {
            return 0;
        }
        adminTopic.setOrder(order);
        this.adminTopicMapper.updateByPrimaryKeySelective(adminTopic);

        forumTopicService.removeCache(id);
        return 1;
    }

    @Override
    public List<AdminTopic> getSimpleList(String key) {
        AdminTopicParam param = new AdminTopicParam();
        param.setTitle(key);
        param.setPageSize(0);
        return adminTopicMapper.getList(param);
    }

    @Override
    public Integer getPostNumByTopicId(Long id) {
        return adminTopicMapper.getPostNumByTopicId(id);
    }

    @Override
    public void batchUpdatePostTopic(Long topicId, List<Long> postIdList) {
        if (CollectionUtils.isNotEmpty(postIdList)) {
            List<Long> topicList = Collections.singletonList(topicId);
            for (Long postId : postIdList) {
                forumPostService.updateTopic(postId, topicList, null);
            }
        }
    }

    private void completeTopic(AdminTopic adminTopic) {
        if (adminTopic != null) {
            adminTopic.setAreaCodes(adminAreaRelationMapper.getAreaCodes(adminTopic.getId(), 2));
            adminTopic.setAreas(locationService.batchFetch(adminTopic.getAreaCodes()));
        }
    }
}
