package com.bxm.localnews.news.util;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author liujia
 * @date 1/14/21 3:46 PM
 **/
public class FormPostContentUtil {
    private FormPostContentUtil() {

    }

    public static void replace(ForumPostVo postVo, LocationDTO location) {
        //开启占位符
        if (Objects.nonNull(postVo)) {
            if (location == null) {
                location = new LocationDTO();
            }

            postVo.setTitle(PlaceHolderUtil.replace(postVo.getTitle(), "areaname", location.getName(), "本地"));
            postVo.setContent(PlaceHolderUtil.replace(postVo.getContent(), "areaname", location.getName(), "本地"));
            postVo.setTextField(PlaceHolderUtil.replace(postVo.getTextField(), "areaname", location.getName(), "本地"));
        }
    }

    public static String getForumPostTitle(String title, String textField) {
        String forumTitle = title;
        if (isNotBlank(forumTitle)) {
            forumTitle = forumTitle.length() > 10 ? forumTitle.substring(0, 10) + "..." : forumTitle;
        } else {
            forumTitle = textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }

    public static String getForumPostTitleTotally(String title, String textField) {
        String forumTitle = title;
        if (StringUtils.isBlank(forumTitle)) {
            forumTitle = textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }
}
