/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.action.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.news.action.PostClickService;
import com.bxm.localnews.news.activity.ForumTeachService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostRecordMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostRecord;
import com.bxm.localnews.news.model.vo.ForumPostStatistic;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.post.PostCountService;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.IPUtil;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PostClickServiceImpl
implements PostClickService {
    private static final Logger log = LoggerFactory.getLogger(PostClickServiceImpl.class);
    private PostCountService postCountService;
    private ForumPostMapper forumPostMapper;
    private ForumPostRecordMapper forumPostRecordMapper;
    private SequenceCreater sequenceCreater;
    private MissionIntegrationService missionIntegrationService;
    private ImageHelper imageHelper;
    private MessageService messageService;
    private HyperLogLogAdapter hyperLogLogAdapter;
    private ForumTeachService forumTeachService;

    @Override
    public void setClickCountInfo(AdminForumPost adminForumPost, AdminForumPost existedAdminForumPost) {
        boolean isRecommend;
        boolean isRecommende;
        boolean isRed;
        boolean isBrilliant;
        boolean isBroke;
        byte yes = 1;
        boolean isUpdate = Objects.nonNull(existedAdminForumPost);
        boolean bl = isUpdate ? !Objects.equals(adminForumPost.getIsBroke(), existedAdminForumPost.getIsBroke()) && Objects.equals(adminForumPost.getIsBroke(), yes) : (isBroke = Objects.equals(adminForumPost.getIsBroke(), yes));
        boolean bl2 = isUpdate ? !Objects.equals(adminForumPost.getIsBrilliant(), existedAdminForumPost.getIsBrilliant()) && Objects.equals(adminForumPost.getIsBrilliant(), yes) : (isBrilliant = Objects.equals(adminForumPost.getIsBrilliant(), yes));
        boolean bl3 = isUpdate ? !Objects.equals(adminForumPost.getIsRed(), existedAdminForumPost.getIsRed()) && Objects.equals(adminForumPost.getIsRed(), yes) : (isRed = Objects.equals(adminForumPost.getIsRed(), yes));
        boolean bl4 = isUpdate ? !Objects.equals(adminForumPost.getIsRecommend(), existedAdminForumPost.getIsRecommend()) && Objects.equals(adminForumPost.getIsRecommend(), yes) : (isRecommende = Objects.equals(adminForumPost.getIsRecommend(), yes));
        boolean isCash = isUpdate ? !Objects.equals(adminForumPost.getIsCash(), existedAdminForumPost.getIsCash()) && Objects.equals(adminForumPost.getIsCash(), yes) : Objects.equals(adminForumPost.getIsCash(), yes);
        boolean bl5 = isRecommend = isBroke || isBrilliant || isRed || isRecommende || isCash;
        if (Objects.isNull(existedAdminForumPost) || Objects.isNull(existedAdminForumPost.getInitialBasicNum()) || Objects.isNull(existedAdminForumPost.getReviewCount())) {
            long initialBasicNum = this.postCountService.getInitialBasicNum(adminForumPost.getAreaCode(), isRecommend);
            adminForumPost.setInitialBasicNum(Long.valueOf(initialBasicNum));
            adminForumPost.setFinalClickCount(Long.valueOf(this.postCountService.getFinalClickCount(Objects.isNull(existedAdminForumPost) || Objects.isNull(existedAdminForumPost.getReviewCount()) ? 0L : existedAdminForumPost.getReviewCount(), initialBasicNum)));
        } else if (isRecommend) {
            long initialBasicNum = this.postCountService.getInitialBasicNum(adminForumPost.getAreaCode(), true);
            if (initialBasicNum > existedAdminForumPost.getInitialBasicNum()) {
                adminForumPost.setInitialBasicNum(Long.valueOf(initialBasicNum));
            } else {
                initialBasicNum = existedAdminForumPost.getInitialBasicNum();
            }
            long reviewCount = existedAdminForumPost.getReviewCount();
            adminForumPost.setFinalClickCount(Long.valueOf(this.postCountService.getFinalClickCount(reviewCount, initialBasicNum)));
        }
    }

    @Override
    public void doConsumeClickCount(Long postId, Long userId, ForumPostVo forumPostVo) {
        long initialBasicNum;
        boolean isUnInit;
        if (Objects.isNull(forumPostVo) && Objects.isNull(forumPostVo = this.forumPostMapper.selectWithoutContent(postId))) {
            return;
        }
        long reviewCount = Objects.isNull(forumPostVo.getReviewCount()) ? 0L : forumPostVo.getReviewCount();
        ++reviewCount;
        boolean bl = isUnInit = Objects.isNull(forumPostVo.getInitialBasicNum()) || forumPostVo.getInitialBasicNum().intValue() == 0;
        if (isUnInit) {
            byte yes = 1;
            boolean isRecommend = Objects.equals(forumPostVo.getIsBroke(), yes) || Objects.equals(forumPostVo.getIsBrilliant(), yes) || Objects.equals(forumPostVo.getIsRed(), yes) || Objects.equals(forumPostVo.getIsRecommend(), yes) || Objects.equals(forumPostVo.getIsCash(), yes);
            initialBasicNum = this.postCountService.getInitialBasicNum(forumPostVo.getAreaCode(), isRecommend);
        } else {
            initialBasicNum = forumPostVo.getInitialBasicNum();
        }
        long finalClickCount = Objects.isNull(forumPostVo.getFinalClickCount()) ? 0L : forumPostVo.getFinalClickCount();
        long currentClickCount = this.postCountService.getFinalClickCount(reviewCount, initialBasicNum);
        currentClickCount = currentClickCount > finalClickCount ? currentClickCount : finalClickCount;
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setClickCount(Integer.valueOf(1));
        forumPostStatistic.setReviewCount(Integer.valueOf(1));
        forumPostStatistic.setFinalClickCount(Long.valueOf(currentClickCount - finalClickCount));
        if (isUnInit) {
            forumPostStatistic.setInitialBasicNum(Long.valueOf(initialBasicNum));
        }
        forumPostStatistic.setId(postId);
        if (log.isDebugEnabled()) {
            log.debug("\u5e16\u5b50: {} \u589e\u52a0\u9605\u8bfb\u6570, \u539f\u6709\u6570\u636e: {} \u65b0\u589e\u540e\u7684\u9605\u8bfb\u6570\u636e: {}", new Object[]{postId, JSON.toJSONString((Object)forumPostVo), JSON.toJSONString((Object)forumPostStatistic)});
        }
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeActiveViewCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setReviewCount(Integer.valueOf(1));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void removePostReadLimit(Long postId) {
        if (null != postId) {
            this.hyperLogLogAdapter.remove(RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey((Object)postId));
        }
    }

    @Override
    public void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {
        ForumPostRecord pRecord = this.forumPostRecordMapper.selectByIds(postId, userId, null);
        Date d = new Date();
        if (pRecord != null) {
            pRecord.setUpdateTime(d);
            this.forumPostRecordMapper.updateByPrimaryKeySelective(pRecord);
        } else {
            ForumPostRecord nr = new ForumPostRecord();
            nr.setId(this.sequenceCreater.nextLongId());
            nr.setPostId(postId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(Integer.valueOf(0));
            nr.setGetGold(Byte.valueOf((byte)1));
            nr.setAddTime(d);
            nr.setLastLocation("1");
            nr.setAdViewType(Byte.valueOf((byte)1));
            this.forumPostRecordMapper.insertSelective(nr);
        }
        this.doConsumeClickCount(postId, userId, forumPostVo);
    }

    @Override
    @Async
    public void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo, String ip) {
        this.doRecordForumPost(userId, postId, shareUserId, platform, forumPostVo);
        if (null != shareUserId && shareUserId != 0L && PlatformEnum.APPLET.getCode() == platform.intValue() && !shareUserId.equals(userId)) {
            String content = "\u8f6c\u53d1\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011\u88ab\u9605\u8bfb";
            NewsCompleTaskDTO firstBrowse = this.missionIntegrationService.compleTask(shareUserId, TaskEnum.TASK_FIRST_BROWSE.name(), userId.toString(), content);
            log.info("\u7528\u6237={}\u5728\u5c0f\u7a0b\u5e8f\u4e2d\u6253\u5f00\u5e16\u5b50,\u65b0\u95fbid={},\u5206\u4eab\u4eba\u7684shareUserId={},\u5b8c\u6210\u4efb\u52a1\u63a5\u53e3\u8fd4\u56de={}", new Object[]{userId, forumPostVo.getId(), shareUserId, JSON.toJSONString((Object)firstBrowse)});
            if (Objects.nonNull(firstBrowse) && firstBrowse.getGoldNum() > 0L) {
                String extendUrl;
                String extendContent = null;
                List imgList = this.imageHelper.getDetailFromPost(forumPostVo.getPostImgList());
                String string = extendUrl = CollectionUtils.isNotEmpty((Collection)imgList) ? null : ((PostImgVo)imgList.get(0)).getImgUrl();
                if (StringUtils.isEmpty(extendUrl)) {
                    extendContent = ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField());
                }
                this.messageService.addMessage(shareUserId, userId, firstBrowse, forumPostVo.getId(), Byte.valueOf(ReplyTypeEnum.POST_REPLY.getCode()), extendUrl, extendContent, forumPostVo.getTitle());
            }
        }
        if (null != platform && PlatformEnum.WEB.getCode() == platform.intValue() && Objects.equals(PostStatusEnum.APPROVING.getCode(), forumPostVo.getStatus())) {
            KeyGenerator keyGenerator = RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey((Object)postId);
            long ipNum = StringUtils.isNotBlank((String)ip) ? IPUtil.ip2long((String)ip) : RandomUtils.nextLong();
            this.hyperLogLogAdapter.add(keyGenerator, (Object[])new Long[]{ipNum});
        }
        if (Objects.equals(PlatformEnum.ANDROID.getCode(), platform) || Objects.equals(PlatformEnum.IOS.getCode(), platform)) {
            try {
                this.forumTeachService.updateTeachInfo(userId, postId);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u7528\u6237\u7684\u6559\u80b2\u7f13\u5b58\u5931\u8d25, userId: {} postId: {}", new Object[]{userId, postId, e});
            }
        }
    }

    public PostClickServiceImpl(PostCountService postCountService, ForumPostMapper forumPostMapper, ForumPostRecordMapper forumPostRecordMapper, SequenceCreater sequenceCreater, MissionIntegrationService missionIntegrationService, ImageHelper imageHelper, MessageService messageService, HyperLogLogAdapter hyperLogLogAdapter, ForumTeachService forumTeachService) {
        this.postCountService = postCountService;
        this.forumPostMapper = forumPostMapper;
        this.forumPostRecordMapper = forumPostRecordMapper;
        this.sequenceCreater = sequenceCreater;
        this.missionIntegrationService = missionIntegrationService;
        this.imageHelper = imageHelper;
        this.messageService = messageService;
        this.hyperLogLogAdapter = hyperLogLogAdapter;
        this.forumTeachService = forumTeachService;
    }
}

