/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.action.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.config.ClientConfigProperties;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.detail.helper.ForumPostImageHelper;
import com.bxm.localnews.news.domain.AdminForumPostLikeMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.model.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.model.dto.PostLikeDto;
import com.bxm.localnews.news.model.param.VirtualUserRandomQueryParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPostLike;
import com.bxm.localnews.news.model.vo.ForumPostLike;
import com.bxm.localnews.news.model.vo.ForumPostStatistic;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.VirtualUser;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PostLikeServiceImpl
implements PostLikeService {
    private static final Logger log = LoggerFactory.getLogger(PostLikeServiceImpl.class);
    private ForumPostLikeMapper forumPostLikeMapper;
    private UserIntegrationService userIntegrationService;
    private UserProperties userProperties;
    private SequenceCreater sequenceCreater;
    private ForumPostMapper forumPostMapper;
    private LocationIntegrationService locationIntegrationService;
    private UserAccountIntegrationService userAccountIntegrationService;
    private AdminForumPostLikeMapper adminForumPostLikeMapper;
    private AdminForumPostMapper adminForumPostMapper;
    private VirtualUserIntegrationService virtualUserIntegrationService;
    private ClientConfigProperties clientConfigProperties;
    private RedisStringAdapter redisStringAdapter;
    private ForumPostImageHelper forumPostImageHelper;
    private MessageService messageService;
    private BizLogIntegrationService bizLogIntegrationService;

    @Override
    public void doLikeForumPost(Long userId, Long postId, int type, String areaCode, Integer platform) {
        log.debug("[\u65e7\u7248]\u7528\u6237\u70b9\u8d5e\u5e16\u5b50\uff0c\u53c2\u6570->postId:{},userId:{},type:{},platform:{}", new Object[]{postId, userId, type, platform});
        ForumPostLike postLike = this.forumPostLikeMapper.selectByUserIdAndPostId(userId, postId);
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        this.generateForumPostLike(postLike, type, postId, userId, userBean);
        this.doUpdateForumInfo(type, postId);
        this.getSelfBean().doAsyncLikePost(userId, postId, type, areaCode, (byte)1, platform);
    }

    private PostLikeService getSelfBean() {
        return (PostLikeService)SpringContextHolder.getBean(PostLikeService.class);
    }

    @Override
    public PostLikeDto doLikeForumPost(Long postId, Long userId, String areaCode, Integer platform) {
        ForumPostLike postLike;
        PostLikeDto postLikeDto = new PostLikeDto();
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userBean.getHeadImg()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userBean.getNickname())) {
            log.info("\u5e16\u5b50\u70b9\u8d5e\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)userBean));
        }
        if (Objects.isNull(postLike = this.forumPostLikeMapper.selectByUserIdAndPostId(userId, postId)) || postLike.getType() == 0) {
            boolean flag;
            long id = this.generateForumPostLike(postLike, 1, postId, userId, userBean);
            this.doUpdateForumInfo(1, postId);
            ForumPostVo postVo = this.forumPostMapper.selectWithoutContent(postId);
            boolean bl = flag = Objects.nonNull(userId) && Objects.nonNull(postVo.getUserId()) && userId.equals(postVo.getUserId());
            if (flag) {
                postLikeDto.setCode(Integer.valueOf(1));
                postLikeDto.setCopyWriter(null);
                postLikeDto.setShowFlower(Integer.valueOf(0));
            } else {
                postLikeDto = this.calculateFlower(postVo, userId, id, areaCode, platform);
            }
            this.userIntegrationService.updateUserLikeNumByUserId(postVo.getUserId());
        } else {
            postLikeDto = null;
        }
        return postLikeDto;
    }

    private PostLikeDto calculateFlower(ForumPostVo postVo, Long userId, Long id, String areaCode, int platform) {
        int postLikeConsume = this.getPostLikeConsume(postVo.getIsBrilliant());
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        FormPostContentUtil.replace(postVo, location);
        String consumeContent = "\u70b9\u8d5e\u3010" + ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()) + "\u3011 \u6d88\u8017\u5c0f\u7ea2\u82b1";
        Boolean consume = this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeExpendParam((Long)userId, (int)postLikeConsume, (Long)id, (String)consumeContent));
        PostLikeDto postLikeDto = new PostLikeDto();
        if (consume.booleanValue()) {
            String addContent = "\u4f60\u53d1\u5e03\u7684\u3010" + ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()) + "\u3011\u88ab\u8d5e";
            this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeAddParam((Long)postVo.getUserId(), (int)postLikeConsume, (Long)id, (String)addContent));
            postLikeDto.setAmount(Integer.valueOf(postLikeConsume));
            postLikeDto.setCode(Integer.valueOf(1));
            this.fillPostLikeDto(postLikeDto, userId, postVo.getUserId(), postLikeConsume);
            this.getSelfBean().doAsyncLikePost(userId, postVo.getId(), 1, areaCode, (byte)0, platform);
        } else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            postLikeDto.setCode(Integer.valueOf(0));
            postLikeDto.setShowFlower(Integer.valueOf(0));
            postLikeDto.setCopyWriter("\u4f60\u7684\u5c0f\u7ea2\u82b1\u4f59\u989d\u4e0d\u8db3\uff0c\u5feb\u8f6c\u53d1\u6587\u7ae0\u8d5a\u5c0f\u7ea2\u82b1");
        }
        return postLikeDto;
    }

    private Long generateForumPostLike(ForumPostLike postLike, int type, Long postId, Long userId, UserBean userBean) {
        long id;
        String updateNickname;
        String updateHeadImg = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userBean.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg();
        String string = updateNickname = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userBean.getNickname()) ? null : userBean.getNickname();
        if (Objects.isNull(postLike)) {
            id = this.sequenceCreater.nextLongId();
            ForumPostLike forumPostLike = ForumPostLike.buildPostLike((Long)postId, (Long)userId);
            forumPostLike.setId(Long.valueOf(id));
            forumPostLike.setType(Byte.valueOf((byte)type));
            forumPostLike.setHeadImg(updateHeadImg);
            forumPostLike.setUserNickname(updateNickname);
            this.forumPostLikeMapper.insertSelective(forumPostLike);
        } else {
            id = postLike.getId();
            postLike.setType(Byte.valueOf((byte)type));
            postLike.setHeadImg(updateHeadImg);
            postLike.setUserNickname(updateNickname);
            this.forumPostLikeMapper.updateByPrimaryKeySelective(postLike);
        }
        return id;
    }

    @Override
    public List<ForumPostLikeDTO> getPostLikeDetail(Long id, Long userId, String devcId) {
        ArrayList result = Lists.newArrayList();
        List forumPostLikes = this.forumPostLikeMapper.selectPostById(id);
        forumPostLikes.forEach(e -> {
            ForumPostLikeDTO postLikeDTO = new ForumPostLikeDTO();
            BeanUtils.copyProperties((Object)e, (Object)postLikeDTO);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)postLikeDTO.getHeadImg())) {
                postLikeDTO.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
            }
            result.add(postLikeDTO);
        });
        return result;
    }

    @Override
    public Message doAddPostLike(Long postId, Date startTime, Date endTime, Integer num) {
        AdminForumPost adminForumPost = this.adminForumPostMapper.selectByPrimaryKey(postId);
        if (Objects.nonNull(adminForumPost)) {
            Long difference = endTime.getTime() - startTime.getTime();
            this.addPostLike(adminForumPost, num, startTime, difference);
        }
        return Message.build((boolean)true);
    }

    private void addPostLike(AdminForumPost adminForumPost, Integer num, Date startTime, Long difference) {
        List exitUserId = this.adminForumPostLikeMapper.selectVirtualUserIdByPostId(adminForumPost.getId());
        exitUserId.add(29211L);
        String areaCode = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)adminForumPost.getAreaCode()) ? adminForumPost.getAreaCode() : "";
        areaCode = (String)Splitter.on((String)",").split((CharSequence)areaCode).iterator().next();
        VirtualUserRandomQueryParam randomQueryParam = new VirtualUserRandomQueryParam();
        randomQueryParam.setNum(num);
        randomQueryParam.setType(null);
        randomQueryParam.setExitUserId(exitUserId);
        randomQueryParam.setAreaCode(areaCode);
        List virtualUsers = this.virtualUserIntegrationService.getRandom(randomQueryParam);
        ArrayList list = Lists.newArrayList();
        for (VirtualUser virtualUser : virtualUsers) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            int amount = (int)(1.0 + Math.random() * (double)difference.longValue());
            calendar.add(14, amount);
            AdminForumPostLike postLike = AdminForumPostLike.builder().addTime(calendar.getTime()).headImg(virtualUser.getHeadImg()).id(this.sequenceCreater.nextLongId()).isShow(Byte.valueOf((byte)0)).isVest(Byte.valueOf((byte)1)).postId(adminForumPost.getId()).type(Byte.valueOf((byte)1)).userId(virtualUser.getId()).userNickname(virtualUser.getNickname()).build();
            list.add(postLike);
        }
        MybatisBatchBuilder.create(AdminForumPostLikeMapper.class, (Collection)list).run(AdminForumPostLikeMapper::insertSelective);
    }

    @Override
    public void simulateData(AdminForumPost adminForumPost) {
        int vestCount = this.adminForumPostLikeMapper.selectByPostIdAndIsVest(adminForumPost.getId());
        if (vestCount < 5) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int num = random.nextInt(10, 20);
            Date date = new Date();
            long difference = 0x6DDD00L;
            this.addPostLike(adminForumPost, num, date, difference);
        }
    }

    @Override
    @Async
    public void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform) {
        if (1 == type) {
            ForumPostVo forumPostVo = this.forumPostMapper.selectWithoutContent(postId);
            this.generateVirtualLike(forumPostVo, isOld);
            if (Objects.nonNull(platform)) {
                this.bizLogIntegrationService.forumLikeSuccessed(userId, postId, areaCode, platform);
            } else {
                isOld = 0;
            }
            FormPostContentUtil.replace(forumPostVo, null);
            this.forumPostImageHelper.exchangeDetailPost(forumPostVo);
            this.messageService.pushPostLikeMessage(forumPostVo, userId, (int)isOld, this.getPostLikeConsume(forumPostVo.getIsBrilliant()));
        }
    }

    private void generateVirtualLike(ForumPostVo forumPostVo, int isOld) {
        if (isOld != 0) {
            return;
        }
        List virtualUserList = this.userIntegrationService.getVirtualUserListNew(Integer.valueOf(20), (List)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), forumPostVo.getAreaCode());
        if (CollectionUtils.isEmpty((Collection)virtualUserList)) {
            return;
        }
        for (VirtualUserInfo virtualUserInfo : virtualUserList) {
            ForumPostLike like = this.forumPostLikeMapper.selectByUserIdAndPostId(virtualUserInfo.getId(), forumPostVo.getId());
            if (!Objects.isNull(like)) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.add(12, 3);
            ForumPostLike postLike = ForumPostLike.buildVestPostLike((Long)this.sequenceCreater.nextLongId(), (Long)forumPostVo.getId(), (Long)virtualUserInfo.getId());
            postLike.setAddTime(calendar.getTime());
            postLike.setHeadImg(virtualUserInfo.getHeadImg());
            postLike.setUserNickname(virtualUserInfo.getNickname());
            this.forumPostLikeMapper.insertSelective(postLike);
            log.debug("\u6dfb\u52a0\u9a6c\u7532\u70b9\u8d5e\u6210\u529f,\u70b9\u8d5e\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)postLike));
            break;
        }
    }

    @Override
    public void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long authorUserId, int postLikeConsume) {
        String dateKey = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        KeyGenerator forumPostLikeTimeKey = RedisConfig.FORUMPOST_LIEK_TIME.copy().appendKey((Object)dateKey).appendKey((Object)userId);
        long likeCount = this.redisStringAdapter.incrementWithDefault(forumPostLikeTimeKey, 1L, 1, 86400L);
        if (likeCount <= 2L) {
            postLikeDto.setCopyWriter("\u5df2\u8d5e\u8d4f\u697c\u4e3b" + postLikeConsume + "\u6735\u5c0f\u7ea2\u82b1");
            postLikeDto.setShowFlower(Integer.valueOf(1));
        } else {
            postLikeDto.setCopyWriter(null);
            postLikeDto.setShowFlower(Integer.valueOf(0));
        }
    }

    @Override
    @Async
    public void asyncSendPostLikeMessage(List<ForumPostLike> postLikes) {
        if (CollectionUtils.isNotEmpty(postLikes)) {
            postLikes.forEach(e -> {
                boolean flag;
                ForumPostVo postVo = this.forumPostMapper.selectWithoutContent(e.getPostId());
                this.userIntegrationService.updateUserLikeNumByUserId(postVo.getUserId());
                int postLikeConsume = this.getPostLikeConsume(postVo.getIsBrilliant());
                boolean bl = flag = !Objects.equals(postVo.getStatus(), PostStatusEnum.USER_DELETE.getCode());
                if (flag) {
                    String addContent = "\u4f60\u53d1\u5e03\u7684\u3010" + ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()) + "\u3011\u88ab\u8d5e";
                    AccountGoldParam usableParam = AccountGoldParam.buildPostLikeAddParam((Long)postVo.getUserId(), (int)postLikeConsume, (Long)e.getId(), (String)addContent);
                    this.userAccountIntegrationService.addGold(usableParam);
                    this.getSelfBean().doAsyncLikePost(e.getUserId(), e.getPostId(), 1, postVo.getAreaCode(), (byte)1, null);
                }
            });
        }
    }

    @Override
    public void doSyncPostLikeInfo() {
        List list = this.forumPostLikeMapper.selectNotExitsUserInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostLike postLike = new ForumPostLike();
            postLike.setUserId(e);
            UserBean userInfo = this.userIntegrationService.selectUserFromCache(e);
            if (Objects.nonNull(userInfo)) {
                postLike.setUserNickname(userInfo.getNickname());
                postLike.setHeadImg(userInfo.getHeadImg());
                paramList.add(postLike);
            }
        });
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, (Collection)paramList).run(ForumPostLikeMapper::updateUserInfoByUserId);
    }

    @Override
    public int getPostLikeConsume(Integer isBrilliant) {
        if (Objects.isNull(isBrilliant) || isBrilliant == 0) {
            return this.clientConfigProperties.getPostCommonLikeConsume();
        }
        return this.clientConfigProperties.getPostBrilliantLikeConsume();
    }

    @Override
    public void doRefreshLikeInfo(Long postId) {
        List postLikes = this.forumPostLikeMapper.selectNotShowPostLike(postId);
        postLikes.forEach(e -> {
            e.setIsShow(Byte.valueOf((byte)1));
            this.forumPostLikeMapper.updateByPrimaryKeySelective(e);
            this.doUpdateForumInfo(1, e.getPostId());
        });
        this.asyncSendPostLikeMessage(postLikes);
        if (!CollectionUtils.isEmpty((Collection)postLikes)) {
            postLikes.size();
        }
    }

    @Override
    @Async
    public void doTriggerUpdateForumPostLikeInfo(Long userId, String nickname, String headImg) {
        if (StringUtils.isBlank((String)nickname) && StringUtils.isBlank((String)headImg)) {
            return;
        }
        this.forumPostLikeMapper.updateNickNameAndHeadImgByUserId(userId, nickname, headImg);
    }

    @Override
    public void doUpdateForumInfo(int type, Long postId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setId(postId);
        forumPostStatistic.setLikeCount(Integer.valueOf(type == 0 ? -1 : 1));
        List forumPostLikes = this.forumPostLikeMapper.selectByPostIdAndOrderByAddtime(postId);
        if (CollectionUtils.isNotEmpty((Collection)forumPostLikes)) {
            forumPostStatistic.setLikeInfo(JSON.toJSONString((Object)forumPostLikes));
        }
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    @Async
    public void addPostLike(ForumPostVo forumPostVo, Integer num) {
        List virtualUserList = this.userIntegrationService.getVirtualUserListNew(Integer.valueOf(num * 2), (List)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), forumPostVo.getAreaCode());
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u5e03\u5e16\u5b50 \u5f02\u6b65\u83b7\u53d6\u70b9\u8d5e\u9a6c\u7532\u6570\u636e \uff1a {}", (Object)JSON.toJSONString((Object)virtualUserList));
        }
        ArrayList list = Lists.newArrayList();
        for (VirtualUserInfo virtualUser : virtualUserList) {
            ForumPostLike like = this.forumPostLikeMapper.selectByUserIdAndPostId(virtualUser.getId(), forumPostVo.getId());
            if (Objects.isNull(like)) {
                Calendar calendar = Calendar.getInstance();
                int amount = (int)(1.0 + Math.random() * 120.0);
                calendar.add(12, amount);
                ForumPostLike postLike = ForumPostLike.builder().addTime(calendar.getTime()).headImg(virtualUser.getHeadImg()).id(this.sequenceCreater.nextLongId()).isShow(Byte.valueOf((byte)0)).isVest(Byte.valueOf((byte)1)).postId(forumPostVo.getId()).type(Byte.valueOf((byte)1)).userId(virtualUser.getId()).userNickname(virtualUser.getNickname()).build();
                list.add(postLike);
            }
            if (list.size() < num) continue;
            break;
        }
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, (Collection)list).run(ForumPostLikeMapper::insertSelective);
    }

    public PostLikeServiceImpl(ForumPostLikeMapper forumPostLikeMapper, UserIntegrationService userIntegrationService, UserProperties userProperties, SequenceCreater sequenceCreater, ForumPostMapper forumPostMapper, LocationIntegrationService locationIntegrationService, UserAccountIntegrationService userAccountIntegrationService, AdminForumPostLikeMapper adminForumPostLikeMapper, AdminForumPostMapper adminForumPostMapper, VirtualUserIntegrationService virtualUserIntegrationService, ClientConfigProperties clientConfigProperties, RedisStringAdapter redisStringAdapter, ForumPostImageHelper forumPostImageHelper, MessageService messageService, BizLogIntegrationService bizLogIntegrationService) {
        this.forumPostLikeMapper = forumPostLikeMapper;
        this.userIntegrationService = userIntegrationService;
        this.userProperties = userProperties;
        this.sequenceCreater = sequenceCreater;
        this.forumPostMapper = forumPostMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.adminForumPostLikeMapper = adminForumPostLikeMapper;
        this.adminForumPostMapper = adminForumPostMapper;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
        this.clientConfigProperties = clientConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.forumPostImageHelper = forumPostImageHelper;
        this.messageService = messageService;
        this.bizLogIntegrationService = bizLogIntegrationService;
    }
}

