/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.action.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.action.PostShareService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostShareMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.NewsShareEnum;
import com.bxm.localnews.news.event.ShareForumActionEvent;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.model.vo.ForumPostShare;
import com.bxm.localnews.news.model.vo.ForumPostStatistic;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.eventbus.EventBus;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostShareServiceImpl
implements PostShareService {
    private static final Logger log = LoggerFactory.getLogger(PostShareServiceImpl.class);
    private BizLogIntegrationService bizLogIntegrationService;
    private MissionIntegrationService missionIntegrationService;
    private UserIntegrationService userIntegrationService;
    private SequenceCreater sequenceCreater;
    private ForumPostShareMapper forumPostShareMapper;
    private ForumPostMapper forumPostMapper;
    private EventBus userActionEventBus;
    private RedisStringAdapter redisStringAdapter;
    private LocationIntegrationService locationIntegrationService;

    @Override
    public NewsCompleTaskDTO doShareForumPost(Long userId, Long postId, String areaCode, Byte type, Integer platform) {
        log.debug("\u7528\u6237\u5206\u4eab\u5e16\u5b50\uff0c\u53c2\u6570->postId:{},userId:{},type:{},platform:{}", new Object[]{postId, userId, type, platform});
        this.bizLogIntegrationService.shareForumSuccessed(userId, postId, areaCode, platform);
        return this.saveShareForums(postId, userId, type, areaCode);
    }

    private NewsCompleTaskDTO saveShareForums(Long postId, Long userId, Byte type, String areaCode) {
        UserBean user = this.userIntegrationService.selectUserFromCache(userId);
        if (user == null || user.getState() != 1) {
            return new NewsCompleTaskDTO();
        }
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        if (NewsShareEnum.SIGN_SHARE.getCode() == type.byteValue()) {
            newsCompleTaskDTO = this.missionIntegrationService.signCompleTaskDTO(userId, "TASK_SIGN_SHARE", postId.toString(), "");
        } else if (NewsShareEnum.SUPPLEMENT_SHARE.getCode() != type.byteValue()) {
            newsCompleTaskDTO = this.completePostShareTask(userId, postId, areaCode);
        }
        ForumPostShare forumPostShare = new ForumPostShare();
        forumPostShare.setAddTime(new Date());
        forumPostShare.setId(this.sequenceCreater.nextLongId());
        forumPostShare.setPostId(postId);
        forumPostShare.setReward(Integer.valueOf(Math.toIntExact(newsCompleTaskDTO.getGoldNum())));
        forumPostShare.setUserId(userId);
        forumPostShare.setType(type);
        this.forumPostShareMapper.insertSelective(forumPostShare);
        ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildShares((Long)postId, (Integer)1);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        this.userActionEventBus.post((Object)ShareForumActionEvent.of().setInviteTypeEnum(InviteTypeEnum.FORUM).setTargetId(postId).setUserId(userId));
        return newsCompleTaskDTO;
    }

    private NewsCompleTaskDTO completePostShareTask(Long userId, Long postId, String areaCode) {
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        KeyGenerator shareRecordKey = this.getShareRecordKey(userId, postId);
        if (!this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
            ForumPostVo forumPostVo = this.forumPostMapper.selectWithoutContent(postId);
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
            FormPostContentUtil.replace(forumPostVo, location);
            String content = "\u8f6c\u53d1\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011\u6210\u529f";
            newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, "TASK_NEWS_SHARE", postId.toString(), content);
            this.redisStringAdapter.set(shareRecordKey, (Object)"exist", (long)DateUtils.getCurSeconds());
        }
        return newsCompleTaskDTO;
    }

    private KeyGenerator getShareRecordKey(Long userId, Long newsId) {
        return RedisConfig.USER_SHARE_NEWS_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)newsId.toString());
    }

    public PostShareServiceImpl(BizLogIntegrationService bizLogIntegrationService, MissionIntegrationService missionIntegrationService, UserIntegrationService userIntegrationService, SequenceCreater sequenceCreater, ForumPostShareMapper forumPostShareMapper, ForumPostMapper forumPostMapper, EventBus userActionEventBus, RedisStringAdapter redisStringAdapter, LocationIntegrationService locationIntegrationService) {
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.missionIntegrationService = missionIntegrationService;
        this.userIntegrationService = userIntegrationService;
        this.sequenceCreater = sequenceCreater;
        this.forumPostShareMapper = forumPostShareMapper;
        this.forumPostMapper = forumPostMapper;
        this.userActionEventBus = userActionEventBus;
        this.redisStringAdapter = redisStringAdapter;
        this.locationIntegrationService = locationIntegrationService;
    }
}

