/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.activity.impl;

import com.bxm.localnews.dto.GoodsInfoAndUserIdDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.news.activity.ActivityPostService;
import com.bxm.localnews.news.domain.activity.ForumPostActivityMapper;
import com.bxm.localnews.news.model.dto.activity.ActivityPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.param.activity.ActivityPostPageParam;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.topic.AdminTopicService;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityPostServiceImpl
implements ActivityPostService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPostServiceImpl.class);
    private ForumPostActivityMapper forumPostActivityMapper;
    private LocationIntegrationService locationIntegrationService;
    private AdminTopicService adminTopicService;
    private SequenceCreater sequenceCreater;
    private MerchantIntegrationService merchantIntegrationService;

    @Override
    public PageWarper<ActivityPostItemDTO> queryByPage(ActivityPostPageParam param) {
        List result = this.forumPostActivityMapper.queryByPage(param);
        result.forEach(post -> {
            AdminTopic adminTopic;
            if (StringUtils.isNotEmpty((CharSequence)post.getAreaDetail())) {
                String[] areaCodeArray = post.getAreaDetail().split(",");
                post.setAreaDetail(this.locationIntegrationService.batchGetDetailJson(areaCodeArray));
            }
            if (null != (adminTopic = this.adminTopicService.selectByPrimaryKey(post.getTopicId()))) {
                post.setTopicName(adminTopic.getTitle());
            }
            post.setLinkUrl(ProtocolFactory.forumPost().outer().postId(post.getId()).noExtend().userId(post.getUserId()).build());
        });
        return new PageWarper(result);
    }

    @Override
    public ForumPostActivityEntity getDetail(Long postId) {
        return this.forumPostActivityMapper.selectByPostId(postId);
    }

    @Override
    public Message save(ForumPostActivityEntity entity) {
        int result;
        ForumPostActivityEntity existsActivityPost = this.getDetail(entity.getPostId());
        if (entity.getGoodsId() != null) {
            GoodsInfoAndUserIdDTO goodsInfo = this.merchantIntegrationService.getMerchantGoodsById(entity.getGoodsId());
            entity.setMerchantId(goodsInfo.getMerchantId());
            entity.setMerchantName(goodsInfo.getMerchantName());
            String goodsDetailHtmlUrl = ProtocolFactory.goods().inner().enablePlaceHolder().goodsId(entity.getGoodsId()).build();
            entity.setProtocol(ProtocolFactory.appH5().url(goodsDetailHtmlUrl).build());
        }
        if (existsActivityPost == null) {
            entity.setId(this.sequenceCreater.nextLongId());
            entity.setCreateTime(new Date());
            if (StringUtils.isBlank((CharSequence)entity.getJoinText())) {
                entity.setJoinText("\u53c2\u4e0e\u6d3b\u52a8");
            }
            result = this.forumPostActivityMapper.insert(entity);
        } else {
            entity.setId(existsActivityPost.getId());
            entity.setModifyTime(new Date());
            entity.setCreator(null);
            result = this.forumPostActivityMapper.updateByPrimaryKeySelective(entity);
        }
        return Message.build((int)result);
    }

    public ActivityPostServiceImpl(ForumPostActivityMapper forumPostActivityMapper, LocationIntegrationService locationIntegrationService, AdminTopicService adminTopicService, SequenceCreater sequenceCreater, MerchantIntegrationService merchantIntegrationService) {
        this.forumPostActivityMapper = forumPostActivityMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.adminTopicService = adminTopicService;
        this.sequenceCreater = sequenceCreater;
        this.merchantIntegrationService = merchantIntegrationService;
    }
}

