/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.activity.impl;

import com.bxm.localnews.news.activity.ForumPostGuideService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.model.dto.ForumPostTodayDTO;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ForumPostGuideServiceImpl
implements ForumPostGuideService {
    private static final Logger log = LoggerFactory.getLogger(ForumPostGuideServiceImpl.class);
    private ForumPostMapper forumPostMapper;
    private RedisSetAdapter redisSetAdapter;
    private NewsProperties newsProperties;
    private ForumTopicService forumTopicService;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public ForumPostTodayDTO forumOkTodayForUser(Long userId) {
        Integer forumsAll = this.forumPostMapper.forumsAllForUser(userId);
        Integer forumsToday = this.forumPostMapper.forumTodayForUser(userId);
        boolean flag = false;
        if (forumsAll <= 3 && forumsToday <= 0 && !this.redisSetAdapter.exists(RedisConfig.FORUM_POST_POP_ONEDAY.copy(), (Object)userId).booleanValue() && this.newsProperties.getForumGuidePopFlag().booleanValue()) {
            flag = true;
            this.saveToRedis(userId);
        }
        return ForumPostTodayDTO.builder().title(this.newsProperties.getForumGuidePopTitle()).subTitle(this.newsProperties.getForumGuidePopSubTitle()).content(this.newsProperties.getForumGuidePopContent()).hasPost(Integer.valueOf(flag ? 1 : 0)).build();
    }

    private void saveToRedis(Long userId) {
        this.redisSetAdapter.add(RedisConfig.FORUM_POST_POP_ONEDAY.copy(), new Object[]{userId});
        this.redisSetAdapter.expire(RedisConfig.FORUM_POST_POP_ONEDAY.copy(), (long)DateUtils.getCurSeconds());
    }

    public ForumPostGuideServiceImpl(ForumPostMapper forumPostMapper, RedisSetAdapter redisSetAdapter, NewsProperties newsProperties, ForumTopicService forumTopicService, RedisHashMapAdapter redisHashMapAdapter) {
        this.forumPostMapper = forumPostMapper;
        this.redisSetAdapter = redisSetAdapter;
        this.newsProperties = newsProperties;
        this.forumTopicService = forumTopicService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

