/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.activity.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.activity.ForumTeachService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.model.dto.UserTeach;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ForumTeachServiceImpl
implements ForumTeachService {
    private static final Logger log = LoggerFactory.getLogger(ForumTeachServiceImpl.class);
    private final ForumProperties forumProperties;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserIntegrationService userIntegrationService;

    @Override
    public Optional<Long> getTeachForumPostId(Long userId, BasicParam basicParam) {
        int index;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: {} \u83b7\u53d6\u6559\u80b2\u4fe1\u606f, basicParam: {}", (Object)userId, (Object)JSON.toJSONString((Object)basicParam));
        }
        if (Objects.isNull(userId)) {
            return Optional.empty();
        }
        if (CollectionUtils.isEmpty((Collection)this.forumProperties.getTeachIds())) {
            if (log.isDebugEnabled()) {
                log.debug("\u6682\u672a\u914d\u7f6e\u6559\u80b2id\uff0c\u8df3\u8fc7\u6559\u80b2");
            }
            return Optional.empty();
        }
        UserTeach teach = (UserTeach)this.redisHashMapAdapter.get(RedisConfig.FORUM_TEACH_CACHE, Objects.toString(userId), UserTeach.class);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: {} \u7684\u6559\u80b2\u4fe1\u606f: {}", (Object)userId, (Object)JSON.toJSONString((Object)teach));
        }
        if (Objects.nonNull(teach) && Objects.equals(teach.getFinished(), Boolean.TRUE)) {
            return Optional.empty();
        }
        if (Objects.isNull(teach) && !this.checkUserIs370VersionUpUser(userId)) {
            return Optional.empty();
        }
        if (Objects.isNull(teach) || Objects.isNull(teach.getForumIndex())) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237: {}\u7b2c\u4e00\u6b21\u88ab\u6559\u80b2\uff0c\u83b7\u53d6\u5230\u7684\u6559\u80b2id: {}", (Object)userId, this.forumProperties.getTeachIds().get(0));
            }
            return Optional.of(this.forumProperties.getTeachIds().get(0));
        }
        int n = index = Objects.isNull(teach.getForumIndex()) ? 0 : teach.getForumIndex() + 1;
        if (index < this.forumProperties.getTeachIds().size()) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237: {} \u7b2c: {}\u6b21 \u83b7\u53d6\u5230\u7684\u6559\u80b2id: {}", new Object[]{userId, index + 1, this.forumProperties.getTeachIds().get(index)});
            }
            return Optional.of(this.forumProperties.getTeachIds().get(index));
        }
        return Optional.empty();
    }

    @Override
    @Async
    public void updateTeachInfo(Long userId, Long newsId) {
        if (log.isDebugEnabled()) {
            log.debug("\u66f4\u65b0\u7528\u6237: {} \u7684\u6559\u80b2\u4fe1\u606f\uff0c\u5e16\u5b50: {}", (Object)userId, (Object)newsId);
        }
        if (Objects.isNull(userId) || Objects.isNull(newsId)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.forumProperties.getTeachIds()) || !this.forumProperties.getTeachIds().contains(newsId)) {
            return;
        }
        UserTeach teach = (UserTeach)this.redisHashMapAdapter.get(RedisConfig.FORUM_TEACH_CACHE, Objects.toString(userId), UserTeach.class);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: {} \u7684\u6559\u80b2\u4fe1\u606f: {}", (Object)userId, (Object)JSON.toJSONString((Object)teach));
        }
        if (Objects.nonNull(teach) && Objects.equals(teach.getFinished(), Boolean.TRUE)) {
            return;
        }
        if (Objects.isNull(teach)) {
            if (!this.checkUserIs370VersionUpUser(userId)) {
                return;
            }
            teach = new UserTeach();
            teach.setForumIndex(Integer.valueOf(0));
            teach.setFinished(Boolean.valueOf(false));
            teach.setFinishedType(Byte.valueOf((byte)0));
        } else {
            int index;
            int n = index = Objects.isNull(teach.getForumIndex()) ? 0 : teach.getForumIndex() + 1;
            if (index >= this.forumProperties.getTeachIds().size()) {
                teach.setFinished(Boolean.valueOf(true));
                teach.setFinishedType(Byte.valueOf((byte)1));
            } else {
                teach.setForumIndex(Integer.valueOf(index));
                if (index == this.forumProperties.getTeachIds().size() - 1) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u7528\u6237: {} \u5df2\u5b8c\u6210\u6559\u80b2", (Object)userId);
                    }
                    teach.setFinished(Boolean.valueOf(true));
                    teach.setFinishedType(Byte.valueOf((byte)1));
                }
            }
        }
        this.redisHashMapAdapter.put(RedisConfig.FORUM_TEACH_CACHE, Objects.toString(userId), (Object)teach);
    }

    private boolean checkUserIs370VersionUpUser(Long userId) {
        boolean is370VersionUpUser;
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)userBean));
        }
        boolean bl = is370VersionUpUser = Objects.nonNull(userBean) && Objects.nonNull(userBean.getJudgeMarker()) && BitOperatorUtil.getBitAsBoolean((Long)userBean.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_7_0.getIndex());
        if (!is370VersionUpUser) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237: {} \u5c5e\u4e8e\u8001\u7248\u672c\u7528\u6237\u8bbe\u7f6e\u6559\u80b2\u7ed3\u675f\u7f13\u5b58", (Object)userId);
            }
            UserTeach teach = new UserTeach();
            teach.setForumIndex(Integer.valueOf(0));
            teach.setFinished(Boolean.valueOf(true));
            teach.setFinishedType(Byte.valueOf((byte)2));
            this.redisHashMapAdapter.put(RedisConfig.FORUM_TEACH_CACHE, Objects.toString(userId), (Object)teach);
        }
        return is370VersionUpUser;
    }

    public ForumTeachServiceImpl(ForumProperties forumProperties, RedisHashMapAdapter redisHashMapAdapter, UserIntegrationService userIntegrationService) {
        this.forumProperties = forumProperties;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userIntegrationService = userIntegrationService;
    }
}

