/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.activity.impl;

import com.bxm.localnews.integration.PushMsgIntegService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.news.activity.PostAwardService;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.domain.PostAwardMapper;
import com.bxm.localnews.news.model.param.CashAccountParam;
import com.bxm.localnews.news.model.param.EarningsSaveOrUpdateParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.PostAwardBean;
import com.bxm.localnews.news.util.SecurityUtils;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.UserEarningsTypeEnum;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostAwardServiceImpl
implements PostAwardService {
    private static final Logger log = LoggerFactory.getLogger(PostAwardServiceImpl.class);
    private final PostAwardMapper postAwardMapper;
    private final PushMsgIntegService pushMsgIntegService;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final SequenceCreater sequenceCreater;
    private final BizConfigProperties bizConfigProperties;

    @Autowired
    public PostAwardServiceImpl(PostAwardMapper postAwardMapper, PushMsgIntegService pushMsgIntegService, UserAccountIntegrationService userAccountIntegrationService, SequenceCreater sequenceCreater, BizConfigProperties bizConfigProperties) {
        this.postAwardMapper = postAwardMapper;
        this.pushMsgIntegService = pushMsgIntegService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.sequenceCreater = sequenceCreater;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public void execGrantAward(AdminForumPost post, String postTitle) {
        if (null == post) {
            return;
        }
        if (Objects.equals(post.getIsCash(), (byte)0) || Objects.isNull(post.getCashReward())) {
            log.info("\u5e16\u5b50\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u4e0d\u662f\u73b0\u91d1\u5e16\uff0c\u6216\u8005\u65e0\u73b0\u91d1\u5956\u52b1\u91d1\u989d");
            return;
        }
        if (this.postAwardMapper.existsPostId(post.getId()) > 0) {
            log.info("\u5e16\u5b50[{}]\u5df2\u7ecf\u53d1\u653e\u8fc7\u5956\u52b1\uff0c\u4e0d\u91cd\u590d\u53d1\u653e", (Object)post.getId());
            return;
        }
        this.saveAwardRecord(post);
        EarningsSaveOrUpdateParam userEarningsParam = new EarningsSaveOrUpdateParam();
        userEarningsParam.setEarningsType(UserEarningsTypeEnum.POST_REWARD.getEarningsType());
        userEarningsParam.setEarningsTitle("\u7206\u6599\u6709\u5956\u5956\u52b1\u91d1");
        userEarningsParam.setOrderTime(new Date());
        userEarningsParam.setImg(this.bizConfigProperties.getPlatFromImgUrl());
        CashAccountParam param = new CashAccountParam();
        param.setExtData((Object)userEarningsParam);
        param.setAccountAction(AccountActionEnum.POST_REWARD);
        param.setCashFlowType(CashFlowTypeEnum.OTHER);
        param.setAmount(post.getCashReward());
        param.setUserId(post.getUserId());
        param.setRelationId(post.getId());
        param.setRemark("\u60a8\u7684\u5e16\u5b50\u300a" + postTitle + "\u300b\u88ab\u5956\u52b1" + post.getCashReward().stripTrailingZeros().toPlainString() + "\u5143");
        if (this.userAccountIntegrationService.cashAccountOperation(param)) {
            this.pushMsgIntegService.pushAwardMsg(post, postTitle);
        }
    }

    private void saveAwardRecord(AdminForumPost post) {
        PostAwardBean entity = new PostAwardBean();
        entity.setId(this.sequenceCreater.nextLongId());
        entity.setAwardType(Integer.valueOf(1));
        entity.setAwardAmount(post.getCashReward());
        entity.setUserId(post.getUserId());
        entity.setOperator(SecurityUtils.getAdminUserId());
        entity.setPostId(post.getId());
        entity.setCreateTime(new Date());
        this.postAwardMapper.insert(entity);
    }
}

