/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.approve.filter;

import com.bxm.localnews.news.approve.context.PostApproveContext;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;

@FilterBean(group="ADMIN_POST_APPROVE_FILTER")
public class PostApproveCleanFilter
implements IFilter<PostApproveContext> {
    private NoteService noteService;

    public void doFilter(PostApproveContext context) {
        AdminForumPost postInfo = context.getPostInfo();
        if (PostTypeEnum.NOTE.getCode() == postInfo.getPostType().byteValue()) {
            this.noteService.removeCache(postInfo.getUserId());
        }
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public PostApproveCleanFilter(NoteService noteService) {
        this.noteService = noteService;
    }
}

