/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.approve.impl;

import com.bxm.localnews.facade.UserActivityService;
import com.bxm.localnews.news.action.PostClickService;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.approve.PostApproveService;
import com.bxm.localnews.news.approve.context.PostApproveContext;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostApproveHistoryMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPostApproveHistory;
import com.bxm.localnews.param.InviteUserPostCashAwardParam;
import com.bxm.newidea.component.filter.FilterChainExecutor;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostApproveServiceImpl
implements PostApproveService {
    private static final Logger log = LoggerFactory.getLogger(PostApproveServiceImpl.class);
    private final UserActivityService userActivityService;
    private final AdminForumPostMapper adminForumPostMapper;
    private final SequenceCreater sequenceCreater;
    private final PostLikeService postLikeService;
    private final ForumPostApproveHistoryMapper forumPostApproveHistoryMapper;
    private final FilterChainExecutor filterChainExecutor;
    private final PostClickService postClickService;

    private List<Long> parseIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(ids.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
    }

    @Override
    public void batchApprove(String ids, Integer status, String comment, Long operator) {
        List<Long> postIdList = this.parseIds(ids);
        if (CollectionUtils.isEmpty(postIdList)) {
            return;
        }
        PostStatusEnum statusEnum = PostStatusEnum.getByCode((Integer)status);
        if (null == statusEnum) {
            return;
        }
        for (Long postId : postIdList) {
            this.approve(postId, statusEnum, comment, operator);
        }
    }

    @Override
    public void approve(Long postId, PostStatusEnum status, String comment, Long operator) {
        log.info("\u8fd0\u8425\u5ba1\u6838\u5e16\u5b50\uff0cpostID:{},status:{},comment:{},operator:{}", new Object[]{postId, status, comment, operator});
        AdminForumPost adminForumPost = this.adminForumPostMapper.selectByPrimaryKey(postId);
        if (null == adminForumPost) {
            return;
        }
        AdminForumPost updatePost = new AdminForumPost();
        updatePost.setId(postId);
        PostApproveContext context = new PostApproveContext();
        context.setComment(comment);
        context.setOperator(operator);
        context.setModifyStatus(status);
        context.setPostInfo(adminForumPost);
        context.setUpdatePost(updatePost);
        this.filterChainExecutor.doFilter("ADMIN_POST_APPROVE_FILTER", (Object)context);
        if (this.adminForumPostMapper.updateByIdPartSelective(updatePost) > 0) {
            AdminForumPostApproveHistory approveHistory = new AdminForumPostApproveHistory();
            approveHistory.setId(this.sequenceCreater.nextLongId());
            approveHistory.setPostId(postId);
            approveHistory.setStatus(status.getCode());
            approveHistory.setComment(comment);
            approveHistory.setCreator(operator);
            approveHistory.setCreateTime(new Date());
            this.forumPostApproveHistoryMapper.addApproveHistory(approveHistory);
            this.afterApprove(adminForumPost);
        }
    }

    private void afterApprove(AdminForumPost post) {
        if (post.getCreator() == null) {
            this.userActivityService.postPass(InviteUserPostCashAwardParam.builder().postId(post.getId()).userId(post.getUserId()).build());
        }
        this.postLikeService.simulateData(post);
        this.postClickService.removePostReadLimit(post.getId());
    }

    @Override
    public List<AdminForumPostApproveHistory> getApproveHistoryList(Long id, Integer action) {
        return this.forumPostApproveHistoryMapper.getApproveHistoryList(id, action);
    }

    public PostApproveServiceImpl(UserActivityService userActivityService, AdminForumPostMapper adminForumPostMapper, SequenceCreater sequenceCreater, PostLikeService postLikeService, ForumPostApproveHistoryMapper forumPostApproveHistoryMapper, FilterChainExecutor filterChainExecutor, PostClickService postClickService) {
        this.userActivityService = userActivityService;
        this.adminForumPostMapper = adminForumPostMapper;
        this.sequenceCreater = sequenceCreater;
        this.postLikeService = postLikeService;
        this.forumPostApproveHistoryMapper = forumPostApproveHistoryMapper;
        this.filterChainExecutor = filterChainExecutor;
        this.postClickService = postClickService;
    }
}

