/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.content;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.content.ContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContentReplacer {
    private static final Logger log = LoggerFactory.getLogger(ContentReplacer.class);
    private final List<ContentReplace> contentReplaceList;

    @PostConstruct
    public void init() {
        this.contentReplaceList.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    public void replace(ContentContext context) {
        if (Objects.isNull(context) || Objects.isNull(context.getReplaceMap()) || CollectionUtils.isEmpty((Map)context.getReplaceMap())) {
            log.warn("\u66ff\u6362\u5360\u4f4d\u7b26\u5931\u8d25\uff0c\u6570\u636e\u7f3a\u5931 context: {}", (Object)JSON.toJSONString((Object)context));
            return;
        }
        this.contentReplaceList.forEach(p -> p.replace(context));
    }

    public ContentReplacer(List<ContentReplace> contentReplaceList) {
        this.contentReplaceList = contentReplaceList;
    }
}

