/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.content.replace;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.content.ContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractContentReplace
implements ContentReplace {
    private static final Logger log = LoggerFactory.getLogger(AbstractContentReplace.class);

    @Override
    public void replace(ContentContext context) {
        try {
            if (this.preCheck(context)) {
                this.doReplace(context);
            }
        }
        catch (Exception e) {
            log.error("\u7c7b\u578b: {} \u66ff\u6362\u5931\u8d25 context: {}", (Object)JSON.toJSONString((Object)context), (Object)e);
        }
    }

    protected boolean preCheck(ContentContext context) {
        if (Objects.isNull(context) || Objects.isNull(context.getReplaceMap()) || CollectionUtils.isEmpty((Map)context.getReplaceMap())) {
            return false;
        }
        return Arrays.stream(this.supports()).anyMatch(p -> Objects.nonNull(context.getReplaceMap().get(p)) && context.getContent().contains(p.getPlaceHolder()) && Objects.nonNull(((Supplier)context.getReplaceMap().get(p)).get()));
    }

    protected void doReplace(ContentContext context) {
        Arrays.stream(this.supports()).forEach(p -> {
            Object content;
            if (Objects.nonNull(context.getReplaceMap()) && Objects.nonNull(context.getReplaceMap().get(p)) && Objects.nonNull(content = ((Supplier)context.getReplaceMap().get(p)).get()) && StringUtils.isNotBlank((CharSequence)Objects.toString(content))) {
                context.setContent(context.getContent().replace(p.getPlaceHolder(), Objects.toString(content)));
            }
        });
    }
}

