/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.content.replace.html;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.news.config.NewsContentReplaceProperties;
import com.bxm.localnews.news.content.replace.html.AbstractHtmlContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.url.ProtocolFactory;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LotteryFlauntJumpUrlReplace
extends AbstractHtmlContentReplace {
    private static final Logger log = LoggerFactory.getLogger(LotteryFlauntJumpUrlReplace.class);
    @Autowired
    private DomainIntegrationService domainIntegrationService;
    @Autowired
    private NewsContentReplaceProperties newsContentReplaceProperties;
    public static final String LOTTERY_FLAUNT_JUMP_URL_SELECT = "a[" + ForumContentPlaceHolderEnum.LOTTERY_FLAUNT_JUMP_URL.getPlaceHolder() + "]";

    @Override
    protected void doReplace(ContentContext context) {
        Elements elements = context.getDocument().select(LOTTERY_FLAUNT_JUMP_URL_SELECT);
        if (!elements.isEmpty()) {
            elements.forEach(el -> {
                String protocol;
                Supplier basicParamSupplier = context.getReplaceValue(this.supports()[0]);
                ReplaceTopicNeedParam param = (ReplaceTopicNeedParam)basicParamSupplier.get();
                if (Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform()) || Objects.equals(PlatformEnum.IOS.getCode(), param.getPlatform())) {
                    String url;
                    if (Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform()) && StringUtils.isNotBlank((CharSequence)param.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.isLessThan((String)param.getCurVer(), (String)"3.8.0")) {
                        url = this.domainIntegrationService.getServerHostBaseUrl();
                        url = StringUtils.join((Object[])new String[]{url, this.newsContentReplaceProperties.getLotteryFlauntOldAndroidProtocol()});
                    } else {
                        url = this.domainIntegrationService.getInnerH5BaseUrl();
                        url = StringUtils.join((Object[])new String[]{url, this.newsContentReplaceProperties.getLotteryFlauntProtocol()});
                    }
                    url = String.format(url, param.getUserId(), param.getAreaCode(), param.getAreaName());
                    protocol = ProtocolFactory.appH5().url(url).build();
                } else {
                    protocol = this.newsContentReplaceProperties.getLotteryFlauntUrl();
                    el.text(this.newsContentReplaceProperties.getLotteryFlauntText());
                }
                log.info("\u66ff\u6362\u5e16\u5b50\u4e2d\uff0c\u70ab\u8000\u5e16\u5b50\u7684\u8df3\u8f6c\u534f\u8bae: {}", (Object)protocol);
                el.attr("href", protocol);
            });
        }
    }

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{ForumContentPlaceHolderEnum.LOTTERY_FLAUNT_JUMP_URL};
    }
}

