/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.content.replace.html;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.news.content.replace.html.AbstractHtmlContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.url.ProtocolFactory;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TopicJumpUrlReplace
extends AbstractHtmlContentReplace {
    private static final Logger log = LoggerFactory.getLogger(TopicJumpUrlReplace.class);
    private static final String TOPIC_JUMP_URL_SELECT = "a[" + ForumContentPlaceHolderEnum.TOPIC_JUMP_URL.getPlaceHolder() + "]";

    @Override
    protected void doReplace(ContentContext context) {
        Elements elements = context.getDocument().select(TOPIC_JUMP_URL_SELECT);
        if (!elements.isEmpty()) {
            elements.forEach(e -> {
                String topicId = e.attr(ForumContentPlaceHolderEnum.TOPIC_JUMP_URL.getPlaceHolder());
                if (StringUtils.isNotBlank((CharSequence)topicId)) {
                    Supplier basicParamSupplier = context.getReplaceValue(this.supports()[0]);
                    ReplaceTopicNeedParam param = (ReplaceTopicNeedParam)basicParamSupplier.get();
                    String protocol = Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform()) || Objects.equals(PlatformEnum.IOS.getCode(), param.getPlatform()) ? ProtocolFactory.topic().app().topicId(Long.valueOf(topicId)).build() : ProtocolFactory.topic().outer().userId(param.getUserId()).areaName(param.getAreaCode()).areaName(param.getAreaName()).topicId(Long.valueOf(topicId)).build();
                    if (log.isDebugEnabled()) {
                        log.debug("\u5e16\u5b50\u7684\u8bdd\u9898\u8df3\u8f6c\uff0c\u83b7\u53d6\u5230\u7684\u8df3\u8f6c\u534f\u8bae: {}", (Object)protocol);
                    }
                    e.attr("href", protocol);
                }
            });
        }
    }

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{ForumContentPlaceHolderEnum.TOPIC_JUMP_URL};
    }
}

