/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.content.replace.html;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.news.content.replace.html.AbstractHtmlContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.url.ProtocolFactory;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserHomePageJumpUrlReplace
extends AbstractHtmlContentReplace {
    private static final Logger log = LoggerFactory.getLogger(UserHomePageJumpUrlReplace.class);
    private static final String USER_JUMP_URL_SELECT = "a[" + ForumContentPlaceHolderEnum.USER_JUMP_URL.getPlaceHolder() + "]";

    @Override
    protected void doReplace(ContentContext context) {
        Elements elements = context.getDocument().select(USER_JUMP_URL_SELECT);
        if (!elements.isEmpty()) {
            elements.forEach(element -> {
                String userIdStr = element.attr(ForumContentPlaceHolderEnum.USER_JUMP_URL.getPlaceHolder());
                if (StringUtils.isNotBlank((CharSequence)userIdStr)) {
                    Supplier basicParamSupplier = context.getReplaceValue(this.supports()[0]);
                    ReplaceTopicNeedParam param = (ReplaceTopicNeedParam)basicParamSupplier.get();
                    String protocol = Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform()) || Objects.equals(PlatformEnum.IOS.getCode(), param.getPlatform()) ? ProtocolFactory.home().app().userId(Long.valueOf(userIdStr)).build() : ProtocolFactory.home().outer().userId(Long.valueOf(userIdStr)).targetUserId(param.getUserId()).areaCode(param.getAreaCode()).areaName(param.getAreaName()).build();
                    if (log.isDebugEnabled()) {
                        log.debug("\u7528\u6237\u7684\u4e3b\u9875\u8df3\u8f6c\u5730\u5740\u66ff\u6362\uff0c\u6700\u7ec8\u7528\u6237\u7684\u8df3\u8f6c\u534f\u8bae: {}", (Object)protocol);
                    }
                    element.attr("href", protocol);
                }
            });
        }
    }

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{ForumContentPlaceHolderEnum.USER_JUMP_URL};
    }
}

