/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.activity.ActivityPostService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="ADMIN_POST_CREATE_FILTER")
public class AdminPostActivityFilter
implements IFilter<AdminPostContext> {
    private static final Logger log = LoggerFactory.getLogger(AdminPostActivityFilter.class);
    private ActivityPostService activityPostService;

    public void doFilter(AdminPostContext context) {
        AdminForumPost savePost = context.getSavePost();
        if (Objects.isNull(savePost.getActivityPost()) || Objects.equals(savePost.getActivityPost(), 0)) {
            log.debug("[{}]\u4e0d\u662f\u6d3b\u52a8\u8d34\uff0c\u4e0d\u4e88\u5904\u7406", (Object)savePost.getId());
            return;
        }
        ForumPostActivityEntity activityEntity = new ForumPostActivityEntity();
        activityEntity.setPostId(savePost.getId());
        activityEntity.setJoinText(savePost.getJoinText());
        activityEntity.setGoodsId(savePost.getGoodsId());
        activityEntity.setStatus(savePost.getActivityStatus());
        activityEntity.setActivityType(savePost.getActivityType());
        activityEntity.setCreator(context.getOperator());
        this.activityPostService.save(activityEntity);
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public AdminPostActivityFilter(ActivityPostService activityPostService) {
        this.activityPostService = activityPostService;
    }
}

