/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.domain.AdminNewsReplyMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.util.DealContentUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

@FilterBean(group="ADMIN_POST_CREATE_FILTER")
public class AdminPostFillAttributeFilter
implements IFilter<AdminPostContext> {
    private UserIntegrationService userIntegrationService;
    private DealContentUtil dealContentUtil;
    private AdminNewsReplyMapper adminNewsReplyMapper;

    public void doFilter(AdminPostContext context) {
        UserBean userInfo;
        AdminForumPost savePost = context.getSavePost();
        AdminForumPost beforePost = context.getBeforePost();
        if (null == savePost) {
            savePost = new AdminForumPost();
            BeanUtils.copyProperties((Object)context.getRequestPost(), (Object)savePost);
            context.setSavePost(savePost);
        }
        if (null != (userInfo = this.userIntegrationService.selectUserFromCache(savePost.getUserId()))) {
            savePost.setUserImg(userInfo.getHeadImg());
            savePost.setUserName(userInfo.getNickname());
        }
        this.dealContentUtil.analyzeContent(savePost);
        savePost.setAreaCode(StringUtils.isNotBlank((CharSequence)savePost.getAreaCode()) ? savePost.getAreaCode() : null);
        savePost.setCoverList(StringUtils.isNotBlank((CharSequence)savePost.getCoverList()) ? JSON.toJSONString((Object)savePost.getCoverList().split(",")) : null);
        savePost.setEditorMessage(StringUtils.isNotBlank((CharSequence)savePost.getEditorMessage()) ? savePost.getEditorMessage() : null);
        savePost.setModifyTime(new Date());
        if (context.isUpdatePost()) {
            if (Objects.isNull(savePost.getStatus())) {
                savePost.setStatus(beforePost.getStatus());
            }
        } else {
            savePost.setCreateTime(new Date());
            savePost.setCreator(context.getOperator());
            if (Objects.isNull(savePost.getStatus())) {
                savePost.setStatus(PostStatusEnum.NORMAL.getCode());
            }
            savePost.setCommentCount(Integer.valueOf(this.adminNewsReplyMapper.count(savePost.getId())));
            List newsReplies = this.adminNewsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(savePost.getId());
            if (CollectionUtils.isNotEmpty((Collection)newsReplies)) {
                savePost.setReplyInfo(JSONObject.toJSONString((Object)newsReplies));
            }
        }
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public AdminPostFillAttributeFilter(UserIntegrationService userIntegrationService, DealContentUtil dealContentUtil, AdminNewsReplyMapper adminNewsReplyMapper) {
        this.userIntegrationService = userIntegrationService;
        this.dealContentUtil = dealContentUtil;
        this.adminNewsReplyMapper = adminNewsReplyMapper;
    }
}

