/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.hotpost.ShareCashPostService;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="ADMIN_POST_CREATE_FILTER")
public class AdminPostShareCashFilter
implements IFilter<AdminPostContext> {
    private static final Logger log = LoggerFactory.getLogger(AdminPostShareCashFilter.class);
    private ShareCashPostService shareCashPostService;
    private RedisHashMapAdapter redisHashMapAdapter;

    public void doFilter(AdminPostContext context) {
        AdminForumPost savePost = context.getSavePost();
        ForumPostShareCashInfoEntity existsShareCashInfo = this.shareCashPostService.getDetail(savePost.getId());
        ForumPostShareCashInfoEntity entity = new ForumPostShareCashInfoEntity();
        if (null == savePost.getIsShareCash() || Objects.equals(savePost.getIsShareCash(), 0)) {
            if (existsShareCashInfo != null) {
                this.shareCashPostService.changeStatus(savePost.getId(), 0);
            }
            return;
        }
        boolean existsRandomAward = this.redisHashMapAdapter.exists(this.buildHotPostRandomAwardKey(), String.valueOf(savePost.getId()));
        if (Objects.equals(savePost.getIsShareCash(), 1) && !existsRandomAward) {
            this.redisHashMapAdapter.put(this.buildHotPostRandomAwardKey(), String.valueOf(savePost.getId()), (Object)RandomUtils.randomDouble((int)2, (double)8.0, (double)20.0));
        }
        entity.setAmount(savePost.getAmount());
        if (null == savePost.getAwardStartTime()) {
            entity.setAwardStartTime(savePost.getPublishTime());
        } else {
            entity.setAwardStartTime(savePost.getAwardStartTime());
        }
        entity.setAwardEndTime(savePost.getAwardEndTime());
        if (null == existsShareCashInfo) {
            entity.setPostId(savePost.getId());
            entity.setCreator(context.getOperator());
        } else {
            entity.setId(existsShareCashInfo.getId());
            entity.setPostId(existsShareCashInfo.getPostId());
            entity.setStatus(savePost.getIsShareCash());
            if (existsShareCashInfo.getUsedAmount().compareTo(entity.getAmount()) >= 0) {
                entity.setStatus(Integer.valueOf(0));
                log.warn("\u5e16\u5b50[{}]\u7684\u5956\u52b1\u91d1\u989d[{}]\u6bd4\u5df2\u53d1\u653e\u91d1\u989d[{}]\u5c11\uff0c\u8bbe\u7f6e\u4e3a\u4e0b\u7ebf", new Object[]{savePost.getId(), entity.getAmount(), existsShareCashInfo.getUsedAmount()});
            }
        }
        log.info("\u70ed\u6587\u72b6\u6001\u4e3a\uff1a{}", (Object)entity.getStatus());
        if (Objects.equals(savePost.getActivityStatus(), 0)) {
            log.info("\u6d3b\u52a8\u4e0b\u67b6\u8bbe\u7f6e\u70ed\u6587\u72b6\u6001\u4e3a\u8fc7\u671f:{}", (Object)entity.getStatus());
            entity.setStatus(Integer.valueOf(0));
        }
        if (Objects.nonNull(savePost.getAwardEndTime()) && DateUtils.before((Date)savePost.getAwardEndTime(), (Date)new Date())) {
            entity.setStatus(Integer.valueOf(0));
        }
        if (DateUtils.after((Date)savePost.getAwardStartTime(), (Date)new Date())) {
            entity.setStatus(Integer.valueOf(0));
        }
        this.shareCashPostService.save(entity);
    }

    private KeyGenerator buildHotPostRandomAwardKey() {
        return RedisConfig.HOT_POST_INIT_RANDOM_AWARD_KEY.copy();
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public AdminPostShareCashFilter(ShareCashPostService shareCashPostService, RedisHashMapAdapter redisHashMapAdapter) {
        this.shareCashPostService = shareCashPostService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

