/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.domain.AdminTopicMapper;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

@FilterBean(group="ADMIN_POST_CREATE_FILTER")
public class AdminPostTopicFillFilter
implements IFilter<AdminPostContext> {
    private ForumProperties forumProperties;
    private AdminTopicMapper adminTopicMapper;
    private ForumPostService forumPostService;

    public void doFilter(AdminPostContext context) {
        AdminForumPost savePost = context.getSavePost();
        if (Objects.equals(PostTypeEnum.NOTE.getCode(), savePost.getPostType())) {
            savePost.setTopicIdList(Collections.singletonList(this.forumProperties.getNoteTopicId()));
            savePost.setValidDate(DateUtils.addField((Date)savePost.getDisplayTime(), (int)5, (int)savePost.getValidDay()));
        }
        if (CollectionUtils.isNotEmpty((Collection)savePost.getTopicIdList())) {
            AdminTopic adminTopic = this.adminTopicMapper.selectByPrimaryKey((Long)savePost.getTopicIdList().get(0));
            if (adminTopic != null) {
                savePost.setForumContent(adminTopic.getContent());
            }
            savePost.setTopicIds(Joiner.on((String)",").join((Iterable)savePost.getTopicIdList()));
        } else {
            savePost.setTopicIds("");
        }
        this.forumPostService.updateTopic(savePost.getId(), savePost.getTopicIdList(), null);
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public AdminPostTopicFillFilter(ForumProperties forumProperties, AdminTopicMapper adminTopicMapper, ForumPostService forumPostService) {
        this.forumProperties = forumProperties;
        this.adminTopicMapper = adminTopicMapper;
        this.forumPostService = forumPostService;
    }
}

