/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.integration.NewsSeqComponent;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserNoteContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.util.AreaCodeUtils;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.InputFilter;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@FilterBean(group="USER_NOTE_CREATE_FILTER")
public class UserNotePreFillFilter
implements IFilter<UserNoteContext> {
    private static final Logger log = LoggerFactory.getLogger(UserNotePreFillFilter.class);
    private NewsSeqComponent newsSeqComponent;
    private ForumProperties forumProperties;

    public void doFilter(UserNoteContext context) {
        NoteParam noteParam = context.getParam();
        Date currentTime = new Date();
        ForumPostVo forumPostVo = new ForumPostVo();
        BeanUtils.copyProperties((Object)noteParam, (Object)forumPostVo);
        forumPostVo.setPostType(Byte.valueOf(PostTypeEnum.NOTE.getCode()));
        forumPostVo.setStatus(PostStatusEnum.APPROVING.getCode());
        forumPostVo.setId(this.newsSeqComponent.getPostId());
        String noteText = noteParam.getTextField();
        noteText = EmojiCodeParser.replaceSoftbankEmoji((String)noteText);
        noteText = InputFilter.builder((String)noteText).filte();
        forumPostVo.setTextField(noteText);
        forumPostVo.setContent(noteText);
        forumPostVo.setDeliveryType(Integer.valueOf(0));
        if (StringUtils.isNotBlank((String)forumPostVo.getAreaCode())) {
            forumPostVo.setDeliveryType(Integer.valueOf(1));
            forumPostVo.setAreaCode(AreaCodeUtils.completeAreaCode((String)forumPostVo.getAreaCode()));
        }
        forumPostVo.setTopicIdList(Collections.singletonList(this.forumProperties.getNoteTopicId()));
        forumPostVo.setTopicIds(Joiner.on((String)",").join((Iterable)forumPostVo.getTopicIdList()));
        forumPostVo.setValidDate(DateUtils.addField((Date)new Date(), (int)5, (int)forumPostVo.getValidDay()));
        UserBean user = context.getPostUserInfo();
        forumPostVo.setUserImg(user.getHeadImg());
        forumPostVo.setUserName(user.getNickname());
        forumPostVo.setCreateTime(currentTime);
        forumPostVo.setDisplayDateTime(currentTime);
        forumPostVo.setPublishTime(currentTime);
        forumPostVo.setModifyTime(currentTime);
        context.setSaveNote(forumPostVo);
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public UserNotePreFillFilter(NewsSeqComponent newsSeqComponent, ForumProperties forumProperties) {
        this.newsSeqComponent = newsSeqComponent;
        this.forumProperties = forumProperties;
    }
}

