/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.NewsSeqComponent;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="USER_POST_CREATE_FILTER")
public class UserPostAttributeFillFilter
implements IFilter<UserPostContext> {
    private static final Logger log = LoggerFactory.getLogger(UserPostAttributeFillFilter.class);
    private NewsSeqComponent newsSeqComponent;

    public void doFilter(UserPostContext context) {
        ForumPostVo forumPostVo = context.getSavePost();
        if (context.isUpdatePost()) {
            if (!Objects.equals(context.getBeforePost().getStatus(), PostStatusEnum.APPROVING.getCode())) {
                forumPostVo.setIsUserUpdate(Byte.valueOf((byte)1));
            }
            forumPostVo.setIsRecommend(Byte.valueOf((byte)0));
            forumPostVo.setModifyTime(new Date());
        } else {
            if (null == forumPostVo.getId()) {
                forumPostVo.setId(this.newsSeqComponent.getPostId());
            }
            if (null != context.getPostUserInfo()) {
                UserBean user = context.getPostUserInfo();
                if (StringUtils.isBlank((CharSequence)user.getHeadImg()) || StringUtils.isBlank((CharSequence)user.getNickname())) {
                    log.info("\u5e16\u5b50\u4fdd\u5b58\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo\uff1a{}", (Object)JSON.toJSONString((Object)user));
                }
                forumPostVo.setUserImg(user.getHeadImg());
                forumPostVo.setUserName(user.getNickname());
            }
            Date currentTime = new Date();
            forumPostVo.setCreateTime(currentTime);
            if (null == forumPostVo.getDisplayDateTime()) {
                forumPostVo.setDisplayDateTime(currentTime);
            }
            if (null == forumPostVo.getPublishTime()) {
                forumPostVo.setPublishTime(currentTime);
            }
            if (null == forumPostVo.getModifyTime()) {
                forumPostVo.setModifyTime(currentTime);
            }
        }
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public UserPostAttributeFillFilter(NewsSeqComponent newsSeqComponent) {
        this.newsSeqComponent = newsSeqComponent;
    }
}

