/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.util.AreaCodeUtils;
import com.bxm.localnews.news.util.UploadUtils;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.InputFilter;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@FilterBean(group="USER_POST_CREATE_FILTER")
public class UserPostContentAssembleFilter
implements IFilter<UserPostContext> {
    private static final Logger log = LoggerFactory.getLogger(UserPostContentAssembleFilter.class);
    private ForumTopicMapper forumTopicMapper;
    private UploadUtils uploadUtils;

    public void doFilter(UserPostContext context) {
        ForumPostVo savePost = context.getSavePost();
        ForumBasicVo requestPost = context.getRequestPost();
        if (null == savePost) {
            savePost = new ForumPostVo();
            BeanUtils.copyProperties((Object)requestPost, (Object)savePost);
            context.setSavePost(savePost);
        }
        if (StringUtils.isBlank((CharSequence)savePost.getLocation())) {
            savePost.setLocation(null);
        }
        this.assembleContent(savePost);
        if (Objects.nonNull(requestPost.getIsNewReport()) && requestPost.getIsNewReport() == 1) {
            savePost.setStatus(PostStatusEnum.BLOCKED.getCode());
        } else {
            savePost.setStatus(PostStatusEnum.APPROVING.getCode());
        }
        savePost.setIsFirstUserPost(Byte.valueOf((byte)(context.isFirstUserPost() ? 1 : 0)));
        if (context.isDirectlyPassed() && !Objects.equals(requestPost.getIsNewReport(), (byte)1)) {
            savePost.setStatus(PostStatusEnum.NORMAL.getCode());
        }
        if (CollectionUtils.isEmpty((Collection)savePost.getTopicIdList())) {
            savePost.setTopicIds("");
        } else {
            savePost.setTopicIds(Joiner.on((String)",").join((Iterable)savePost.getTopicIdList()));
        }
        if (StringUtils.isBlank((CharSequence)savePost.getAreaCode())) {
            log.info("\u53d1\u5e16\u4fe1\u606f[{}]\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4f7f\u7528\u7528\u6237\u7684\u5f53\u524d\u5b9a\u4f4d\u4fe1\u606f", (Object)savePost.getId());
            if (null != context.getPostUserInfo()) {
                savePost.setAreaCode(context.getPostUserInfo().getLocationCode());
            }
        }
        savePost.setDeliveryType(Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)savePost.getAreaCode())) {
            savePost.setDeliveryType(Integer.valueOf(1));
            savePost.setAreaCode(AreaCodeUtils.completeAreaCode((String)savePost.getAreaCode()));
        }
    }

    private void assembleContent(ForumPostVo savePost) {
        int index;
        TopicVo topic;
        savePost.setTextField(EmojiCodeParser.replaceSoftbankEmoji((String)savePost.getTextField()));
        savePost.setTextField(InputFilter.builder((String)savePost.getTextField()).filte());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)savePost.getTopicIdList()) && (topic = this.forumTopicMapper.selectTopicById((Long)savePost.getTopicIdList().get(0), null)) != null) {
            savePost.setForumContent(topic.getContent());
        }
        if ((index = savePost.getTextField().lastIndexOf("\n")) != -1 && index == savePost.getTextField().length() - 1) {
            savePost.setTextField(savePost.getTextField().substring(0, savePost.getTextField().length() - 1));
        }
        StringBuilder content = new StringBuilder("<p>");
        if (StringUtils.isNotBlank((CharSequence)savePost.getTextField())) {
            content.append(savePost.getTextField().replaceAll("\\n", "</p><p>"));
        }
        content.append("</p>");
        if (StringUtils.isNotBlank((CharSequence)savePost.getExtraContent())) {
            content.append("<p>");
            content.append(savePost.getExtraContent());
            content.append("</p>");
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)savePost.getPostImgList())) {
            this.dealPostImgList(savePost, content);
        }
        savePost.setContent(content.toString());
    }

    private void dealPostImgList(ForumPostVo forumPostVo, StringBuilder content) {
        forumPostVo.getPostImgList().forEach(e -> {
            if (StringUtils.isBlank((CharSequence)e.getType())) {
                e.setType("IMG");
            }
        });
        List postVideoList = forumPostVo.getPostImgList().stream().filter(e -> "VIDEO".equals(e.getType())).collect(Collectors.toList());
        List postImgList = forumPostVo.getPostImgList().stream().filter(e -> "IMG".equals(e.getType())).collect(Collectors.toList());
        for (PostImgVo postImgVo : postVideoList) {
            if (!StringUtils.isNotBlank((CharSequence)postImgVo.getVideoUrl())) continue;
            content.append("<p>&nbsp;<video controls=\"controls\" src=\"");
            content.append(postImgVo.getVideoUrl());
            content.append("\" poster=\"");
            content.append(postImgVo.getImgUrl());
            content.append("\" size=\"");
            content.append(postImgVo.getSize() == null ? Integer.valueOf(0) : postImgVo.getSize());
            content.append("\" duration=\"");
            content.append(postImgVo.getDuration() == null ? 0L : postImgVo.getDuration());
            content.append("\"></video>&nbsp;</p>");
        }
        for (PostImgVo postImgVo : postImgList) {
            String imgUrl = postImgVo.getImgUrl();
            if (!StringUtils.contains((CharSequence)imgUrl, (CharSequence)"wstong.com")) {
                imgUrl = this.uploadUtils.uploadImgToOssBySrc(imgUrl);
            }
            if (!StringUtils.isNotBlank((CharSequence)postImgVo.getImgUrl())) continue;
            content.append("<p><img src=\"");
            content.append(imgUrl);
            content.append("\"></img></p>");
        }
        postVideoList.addAll(postImgList);
        forumPostVo.setPostImgList(postVideoList);
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public UserPostContentAssembleFilter(ForumTopicMapper forumTopicMapper, UploadUtils uploadUtils) {
        this.forumTopicMapper = forumTopicMapper;
        this.uploadUtils = uploadUtils;
    }
}

