/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.NewsSeqComponent;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.ForumPostCreateConvert;
import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.create.context.UserNoteContext;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.event.AdminPostCreateEvent;
import com.bxm.localnews.news.event.UserNoteCreateEvent;
import com.bxm.localnews.news.event.UserPostCreateEvent;
import com.bxm.localnews.news.model.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.newidea.component.filter.FilterChainExecutor;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.rule.RuleGroupExecutor;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostCreateServiceImpl
implements PostCreateService {
    private static final Logger log = LoggerFactory.getLogger(PostCreateServiceImpl.class);
    private final FilterChainExecutor filterChainExecutor;
    private final RuleGroupExecutor ruleGroupExecutor;
    private final SequenceCreater sequenceCreater;
    private final DistributedLock distributedLock;
    private final ForumPostMapper forumPostMapper;
    private final NewsSeqComponent newsSeqComponent;
    private final UserIntegrationService userIntegrationService;
    private final ForumPostCreateConvert forumPostCreateConvert;
    private final AdminForumPostMapper adminForumPostMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final ForumPostService forumPostService;

    @Override
    public Message saveUserPost(ForumBasicVo forumBasicVo, BasicParam basicParam, boolean isDirectlyPassed) {
        log.info("\u7528\u6237\u53d1\u5e16 forumBasicVo:[{}]\uff0cbasicParam\uff1a{},isDirectlyPassed:{}", new Object[]{JSON.toJSONString((Object)forumBasicVo), JSON.toJSONString((Object)basicParam), isDirectlyPassed});
        if (Objects.isNull(forumBasicVo.getAreaCode())) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u6240\u5c5e\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KeyGenerator lockKey = RedisConfig.NEW_REPORT_LOCK.copy().appendKey((Object)forumBasicVo.getUserId());
        String stringId = this.sequenceCreater.nextStringId();
        if (!this.distributedLock.lock(lockKey.gen(), stringId)) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u9891\u7e41\u53d1\u5e16");
        }
        UserPostContext context = new UserPostContext();
        context.setBasicParam(basicParam);
        context.setRequestPost(forumBasicVo);
        context.setDirectlyPassed(isDirectlyPassed);
        context.setSaveOrUpdate(null == forumBasicVo.getId());
        context.setPostUserInfo(this.userIntegrationService.selectUserFromCache(forumBasicVo.getUserId()));
        if (context.isUpdatePost()) {
            context.setBeforePost(this.forumPostMapper.selectWithoutContent(forumBasicVo.getId()));
        } else {
            forumBasicVo.setId(this.newsSeqComponent.getPostId());
        }
        if (!this.ruleGroupExecutor.apply("USER_POST_CREATE_RULE", (Object)context)) {
            return Message.build((boolean)false, (String)context.getErrorMsg());
        }
        this.filterChainExecutor.doFilter("USER_POST_CREATE_FILTER", (Object)context);
        Message message = Message.build();
        if (context.isUpdatePost()) {
            this.forumPostMapper.updateByPrimaryKeySelective(context.getSavePost());
        } else if (this.forumPostMapper.insertSelective(context.getSavePost()) > 0) {
            ForumPostVo forumPostVo = context.getSavePost();
            NewsCompleTaskDTO newsCompleTaskDTO = this.forumPostService.completeTask(forumPostVo);
            ForumPostCreateDTO forumPostCreateDTO = this.forumPostCreateConvert.generateForumPost(forumPostVo, newsCompleTaskDTO, forumBasicVo.getUserId());
            message.addParam("completeTaskAndPush", (Object)forumPostCreateDTO);
        } else {
            return Message.build((boolean)false, (String)"\u53d1\u5e16\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        SpringContextHolder.getApplicationContext().publishEvent((Object)new UserPostCreateEvent(context));
        return message;
    }

    @Override
    public Message saveUserNote(NoteParam param) {
        log.info("\u7528\u6237\u53d1\u5e03\u5c0f\u7eb8\u6761\uff1a{}", (Object)param);
        UserNoteContext context = new UserNoteContext();
        context.setParam(param);
        if (null != param.getUserId()) {
            context.setPostUserInfo(this.userIntegrationService.selectUserFromCache(param.getUserId()));
        }
        if (!this.ruleGroupExecutor.apply("USER_NOTE_CREATE_RULE", (Object)context)) {
            return Message.build((boolean)false, (String)context.getErrorMsg());
        }
        this.filterChainExecutor.doFilter("USER_NOTE_CREATE_FILTER", (Object)context);
        if (this.forumPostMapper.insertSelective(context.getSaveNote()) > 0) {
            SpringContextHolder.getApplicationContext().publishEvent((Object)new UserNoteCreateEvent(context));
        }
        return Message.build().addParam("note", (Object)context.getResponseNote());
    }

    @Override
    public Message saveAdminPost(AdminForumPost adminForumPost, Long operator) {
        String stringId = this.sequenceCreater.nextStringId();
        if (!this.distributedLock.lock(this.buildSaveOrUpdatePostKey(adminForumPost.getId()), stringId)) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u9891\u7e41\u53d1\u5e16");
        }
        AdminForumPost existedAdminForumPost = this.adminForumPostMapper.selectByPrimaryKey(adminForumPost.getId());
        log.info("\u8fd0\u8425\u64cd\u4f5c\u53d1\u5e16\uff0c\u53c2\u6570:[{}],\u539f\u6709\u6570\u636e:[{}]", (Object)JSONObject.toJSONString((Object)adminForumPost), (Object)JSONObject.toJSONString((Object)existedAdminForumPost));
        AdminPostContext context = new AdminPostContext();
        context.setBeforePost(existedAdminForumPost);
        context.setRequestPost(adminForumPost);
        context.setOperator(operator);
        context.setSaveOrUpdate(null == existedAdminForumPost);
        if (!this.ruleGroupExecutor.apply("ADMIN_POST_CREATE_RULE", (Object)context)) {
            return Message.build((boolean)false, (String)context.getErrorMsg());
        }
        this.filterChainExecutor.doFilter("ADMIN_POST_CREATE_FILTER", (Object)context);
        AdminForumPost savePost = context.getSavePost();
        if (context.isUpdatePost()) {
            this.adminForumPostMapper.updateByIdPartSelective(savePost);
        } else {
            this.adminForumPostMapper.insertSelective(savePost);
        }
        SpringContextHolder.getApplicationContext().publishEvent((Object)new AdminPostCreateEvent(context));
        this.distributedLock.unlock(this.buildSaveOrUpdatePostKey(adminForumPost.getId()), stringId);
        return Message.build();
    }

    private String buildSaveOrUpdatePostKey(Long postId) {
        return RedisConfig.SAVE_OR_UPDATE_POST_KEY.copy().appendKey((Object)postId).gen();
    }

    public PostCreateServiceImpl(FilterChainExecutor filterChainExecutor, RuleGroupExecutor ruleGroupExecutor, SequenceCreater sequenceCreater, DistributedLock distributedLock, ForumPostMapper forumPostMapper, NewsSeqComponent newsSeqComponent, UserIntegrationService userIntegrationService, ForumPostCreateConvert forumPostCreateConvert, AdminForumPostMapper adminForumPostMapper, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, ForumPostService forumPostService) {
        this.filterChainExecutor = filterChainExecutor;
        this.ruleGroupExecutor = ruleGroupExecutor;
        this.sequenceCreater = sequenceCreater;
        this.distributedLock = distributedLock;
        this.forumPostMapper = forumPostMapper;
        this.newsSeqComponent = newsSeqComponent;
        this.userIntegrationService = userIntegrationService;
        this.forumPostCreateConvert = forumPostCreateConvert;
        this.adminForumPostMapper = adminForumPostMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.forumPostService = forumPostService;
    }
}

