/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.listener;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.integration.PushMsgIntegService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.news.action.PostClickService;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.activity.PostAwardService;
import com.bxm.localnews.news.approve.PostApproveService;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.event.AdminPostCreateEvent;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.localnews.news.post.ForumPostContentService;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.post.PostTagService;
import com.bxm.localnews.news.recommend.RecommendPostService;
import com.bxm.localnews.news.statistics.ForumPostStatisticService;
import com.bxm.localnews.news.util.FormPostContentUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class AdminPostCreateListener {
    private static final Logger log = LoggerFactory.getLogger(AdminPostCreateListener.class);
    private final PostAwardService postAwardService;
    private final PostTagService postTagService;
    private final ForumPostContentService forumPostContentService;
    private final PostClickService postClickService;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final PushMsgIntegService pushMsgIntegService;
    private final DomainIntegrationService domainIntegrationService;
    private final PostApproveService postApproveService;
    private final RecommendPostService recommendPostService;
    private final PostLikeService postLikeService;
    private final ForumPostStatisticService forumPostStatisticService;
    private final NoteService noteService;
    private final ForumPostService forumPostService;

    @EventListener
    public void addPostAward(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        if (context.isUpdatePost()) {
            AdminForumPost post = context.getSavePost();
            this.postAwardService.execGrantAward(post, FormPostContentUtil.getForumPostTitle(post.getTitle(), post.getTextField()));
        }
    }

    @EventListener
    public void triggerApprove(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost savePost = context.getSavePost();
        AdminForumPost beforePost = context.getBeforePost();
        if (context.isUpdatePost() && !Objects.equals(savePost.getStatus(), beforePost.getStatus()) && this.isPostShow(savePost.getStatus())) {
            log.info("\u8fd0\u8425\u7ba1\u7406\u5458[{}]\u5bf9\u6b64\u5e16\u5b50\u8fdb\u884c\u4fdd\u5b58:[{}]", (Object)context.getOperator(), (Object)JSONObject.toJSONString((Object)savePost));
            this.postApproveService.approve(savePost.getId(), PostStatusEnum.getByCode((Integer)savePost.getStatus()), null, context.getOperator());
        }
    }

    private boolean isPostShow(Integer status) {
        return Objects.equals(status, PostStatusEnum.NORMAL.getCode()) || Objects.equals(status, PostStatusEnum.SELF.getCode()) || Objects.equals(status, PostStatusEnum.BLOCKED.getCode());
    }

    @EventListener
    public void resetPostTag(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost post = context.getSavePost();
        this.postTagService.resetForumPostTag(post);
    }

    @EventListener
    public void transCodePostVideo(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost post = context.getSavePost();
        this.forumPostService.execTransCode(post.getId(), post.getImgList(), null);
    }

    @EventListener
    public void addMockData(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost adminForumPost = context.getSavePost();
        this.postClickService.setClickCountInfo(context.getSavePost(), context.getBeforePost());
        if (!context.isUpdatePost()) {
            this.postLikeService.simulateData(adminForumPost);
        }
    }

    @EventListener
    public void addStatisticsData(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost adminForumPost = context.getSavePost();
        if (!context.isUpdatePost()) {
            this.forumPostStatisticService.addCrumbsTotal(adminForumPost.getDeliveryType(), adminForumPost.getAreaCode(), adminForumPost.getPostType());
        }
    }

    @EventListener
    public void updateRecommend(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost adminForumPost = context.getSavePost();
        if (context.isUpdatePost()) {
            this.recommendPostService.updateRecommendWhenChanged(adminForumPost);
        }
    }

    @EventListener
    public void sendPush(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost post = context.getSavePost();
        AdminForumPost existsPost = context.getBeforePost();
        this.forumPostContentService.afterCreate(post);
        if (context.isUpdatePost() && Objects.equals(post.getStatus(), PostStatusEnum.NORMAL.getCode())) {
            String forumPostTitle = FormPostContentUtil.getForumPostTitle(post.getTitle(), post.getTextField());
            this.userAccountIntegrationService.addUserGold(post, existsPost, forumPostTitle);
            this.pushMsgIntegService.pushMsg(post, existsPost, forumPostTitle, this.domainIntegrationService.getInnerH5BaseUrl());
        }
    }

    @EventListener
    public void removeNoteCache(AdminPostCreateEvent event) {
        AdminPostContext context = event.getContext();
        AdminForumPost adminForumPost = context.getSavePost();
        if (Objects.equals(PostTypeEnum.NOTE.getCode(), adminForumPost.getPostType())) {
            this.noteService.removeCache(adminForumPost.getUserId());
        }
    }

    public AdminPostCreateListener(PostAwardService postAwardService, PostTagService postTagService, ForumPostContentService forumPostContentService, PostClickService postClickService, UserAccountIntegrationService userAccountIntegrationService, PushMsgIntegService pushMsgIntegService, DomainIntegrationService domainIntegrationService, PostApproveService postApproveService, RecommendPostService recommendPostService, PostLikeService postLikeService, ForumPostStatisticService forumPostStatisticService, NoteService noteService, ForumPostService forumPostService) {
        this.postAwardService = postAwardService;
        this.postTagService = postTagService;
        this.forumPostContentService = forumPostContentService;
        this.postClickService = postClickService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.pushMsgIntegService = pushMsgIntegService;
        this.domainIntegrationService = domainIntegrationService;
        this.postApproveService = postApproveService;
        this.recommendPostService = recommendPostService;
        this.postLikeService = postLikeService;
        this.forumPostStatisticService = forumPostStatisticService;
        this.noteService = noteService;
        this.forumPostService = forumPostService;
    }
}

