/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.listener;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.event.NoteActionEvent;
import com.bxm.localnews.news.event.UserActionEvent;
import com.bxm.localnews.news.event.UserNoteCreateEvent;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.statistics.ForumPostStatisticService;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.google.common.eventbus.EventBus;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UserNoteCreateListener {
    private static final Logger log = LoggerFactory.getLogger(UserNoteCreateListener.class);
    private final ForumTopicService forumTopicService;
    private final ForumPostStatisticService forumPostStatisticService;
    private final EventBus userActionEventBus;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final NoteService noteService;
    private final UserIntegrationService userIntegrationService;
    private final ForumPostService forumPostService;

    @EventListener
    public void modifyTopic(UserNoteCreateEvent event) {
        NoteParam noteParam = event.getContext().getParam();
        ForumPostVo forumPostVo = event.getContext().getSaveNote();
        this.forumPostService.updateTopic(forumPostVo.getId(), forumPostVo.getTopicIdList(), forumPostVo.getSecondTopicId());
        this.noteService.removeCache(noteParam.getUserId());
    }

    @EventListener
    public void addStatisticsData(UserNoteCreateEvent event) {
        NoteParam noteParam = event.getContext().getParam();
        ForumPostVo forumPostVo = event.getContext().getSaveNote();
        if (StringUtils.isBlank((CharSequence)noteParam.getAreaCode())) {
            this.forumPostStatisticService.addCrumbsTotal(0, noteParam.getAreaCode(), (byte)2);
        } else {
            this.forumPostStatisticService.addCrumbsTotal(1, noteParam.getAreaCode(), (byte)2);
        }
        this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(1));
    }

    @EventListener
    public void sendEvent(UserNoteCreateEvent event) {
        NoteParam noteParam = event.getContext().getParam();
        ForumPostVo forumPostVo = event.getContext().getSaveNote();
        UserActionEvent userActionEvent = NoteActionEvent.of().setLastNoteId(forumPostVo.getId()).setLastNoteTime(new Date()).setUserId(noteParam.getUserId());
        this.userActionEventBus.post((Object)userActionEvent);
    }

    @EventListener
    public void addLog(UserNoteCreateEvent event) {
        NoteParam noteParam = event.getContext().getParam();
        ForumPostVo forumPostVo = event.getContext().getSaveNote();
        this.bizLogIntegrationService.noteSucceed((BasicParam)noteParam, forumPostVo.getId(), forumPostVo.getUserId(), forumPostVo.getAreaCode());
    }

    public UserNoteCreateListener(ForumTopicService forumTopicService, ForumPostStatisticService forumPostStatisticService, EventBus userActionEventBus, BizLogIntegrationService bizLogIntegrationService, NoteService noteService, UserIntegrationService userIntegrationService, ForumPostService forumPostService) {
        this.forumTopicService = forumTopicService;
        this.forumPostStatisticService = forumPostStatisticService;
        this.userActionEventBus = userActionEventBus;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.noteService = noteService;
        this.userIntegrationService = userIntegrationService;
        this.forumPostService = forumPostService;
    }
}

