/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.listener;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.event.ForumPostActionEvent;
import com.bxm.localnews.news.event.UserActionEvent;
import com.bxm.localnews.news.event.UserPostCreateEvent;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.post.PostCountService;
import com.bxm.localnews.news.statistics.ForumPostStatisticService;
import com.bxm.localnews.news.task.FirstPostLikeCallback;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.eventbus.EventBus;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserPostCreateListener {
    private static final Logger log = LoggerFactory.getLogger(UserPostCreateListener.class);
    private final PostLikeService postLikeService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private final EventBus userActionEventBus;
    private final BizLogIntegrationService bizLogIntegrationService;
    private final ForumPostStatisticService forumPostStatisticService;
    private final PostCountService postCountService;
    private final ForumPostService forumPostService;
    private UserIntegrationService userIntegrationService;
    private final ScheduleService scheduleService;
    private final FirstPostLikeCallback firstPostLikeCallback;

    @EventListener
    public void setPostTopic(UserPostCreateEvent event) {
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        this.forumPostService.updateTopic(forumPostVo.getId(), forumPostVo.getTopicIdList(), forumPostVo.getSecondTopicId());
    }

    @EventListener
    public void addCrumbsAreaTotal(UserPostCreateEvent event) {
        if (event.getContext().isUpdatePost()) {
            return;
        }
        ForumBasicVo forumBasicVo = event.getContext().getRequestPost();
        KeyGenerator crumbsAreaTotalKey = RedisConfig.CRUMBS_AREA_TOTAL.copy().appendKey((Object)1);
        boolean keyExists = this.redisHashMapAdapter.exists(crumbsAreaTotalKey, forumBasicVo.getAreaCode());
        if (keyExists) {
            this.redisHashMapAdapter.increment(crumbsAreaTotalKey, forumBasicVo.getAreaCode(), 1);
        } else {
            boolean initNum = true;
            this.redisHashMapAdapter.put(crumbsAreaTotalKey, forumBasicVo.getAreaCode(), (Object)1);
        }
    }

    @EventListener
    public void cancelRecommend(UserPostCreateEvent event) {
        UserPostContext context = event.getContext();
        if (context.isUpdatePost()) {
            Long postId = context.getSavePost().getId();
            this.mixedRecommendPoolMapper.deleteMixRecommandPoolById(postId);
        }
    }

    @EventListener
    public void sendUserPostEvent(UserPostCreateEvent event) {
        if (event.getContext().isUpdatePost()) {
            return;
        }
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        UserActionEvent userActionEvent = ForumPostActionEvent.of().setLastPostId(forumPostVo.getId()).setLastPostTime(new Date()).setUserId(forumPostVo.getUserId());
        this.userActionEventBus.post((Object)userActionEvent);
    }

    @EventListener
    public void reportBizLog(UserPostCreateEvent event) {
        if (event.getContext().isUpdatePost()) {
            return;
        }
        ForumBasicVo forumBasicVo = event.getContext().getRequestPost();
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        BasicParam basicParam = event.getContext().getBasicParam();
        if (Objects.nonNull(forumBasicVo.getIsNewReport()) && forumBasicVo.getIsNewReport() == 1) {
            PointReportParam reportParam = PointReportParam.build((BasicParam)basicParam).e("3034").ev("122." + forumPostVo.getId()).put("uid", String.valueOf(forumPostVo.getUserId())).put("a", forumPostVo.getAreaCode());
            this.bizLogIntegrationService.point(reportParam);
        }
        if (basicParam != null) {
            PointReportParam param = PointReportParam.build((BasicParam)basicParam);
            param.e("2011").put("a", forumPostVo.getAreaCode()).put("nid", String.valueOf(forumPostVo.getId())).put("uid", String.valueOf(forumPostVo.getUserId()));
            this.bizLogIntegrationService.point(param);
        }
    }

    @EventListener
    public void addVirtualLikeAndComment(UserPostCreateEvent event) {
        if (event.getContext().isUpdatePost()) {
            return;
        }
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        if (Objects.equals(PostStatusEnum.BLOCKED.getCode(), forumPostVo.getStatus()) || Objects.equals(forumPostVo.getIsNewReport(), (byte)1)) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int num = random.nextInt(5, 20);
            this.postLikeService.addPostLike(forumPostVo, num);
            this.forumPostStatisticService.addPostReply(forumPostVo);
            Date fireDate = DateUtils.addField((Date)new Date(), (int)13, (int)30);
            this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((Date)fireDate, (TaskCallback)this.firstPostLikeCallback).taskName("firstRefreshPostLike_" + forumPostVo.getId()).build());
        }
    }

    @EventListener
    public void addClickCount(UserPostCreateEvent event) {
        if (event.getContext().isUpdatePost()) {
            return;
        }
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        long initialBasicNum = this.postCountService.getInitialBasicNum(forumPostVo.getAreaCode(), false);
        forumPostVo.setInitialBasicNum(Long.valueOf(initialBasicNum));
        forumPostVo.setFinalClickCount(Long.valueOf(this.postCountService.getFinalClickCount(0L, initialBasicNum)));
    }

    @EventListener
    public void addUserPublishNum(UserPostCreateEvent event) {
        if (event.getContext().isUpdatePost()) {
            return;
        }
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(1));
    }

    @EventListener
    @Async
    public void transCodePostVideo(UserPostCreateEvent event) {
        ForumPostVo forumPostVo = event.getContext().getSavePost();
        if (log.isDebugEnabled()) {
            log.debug("\u89e6\u53d1\u89c6\u9891\u8f6c\u7801,\u5e16\u5b50ID\uff1a{}", (Object)forumPostVo.getId());
        }
        this.forumPostService.execTransCode(forumPostVo.getId(), null, forumPostVo.getPostImgList());
    }

    public UserPostCreateListener(PostLikeService postLikeService, RedisHashMapAdapter redisHashMapAdapter, MixedRecommendPoolMapper mixedRecommendPoolMapper, EventBus userActionEventBus, BizLogIntegrationService bizLogIntegrationService, ForumPostStatisticService forumPostStatisticService, PostCountService postCountService, ForumPostService forumPostService, UserIntegrationService userIntegrationService, ScheduleService scheduleService, FirstPostLikeCallback firstPostLikeCallback) {
        this.postLikeService = postLikeService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.userActionEventBus = userActionEventBus;
        this.bizLogIntegrationService = bizLogIntegrationService;
        this.forumPostStatisticService = forumPostStatisticService;
        this.postCountService = postCountService;
        this.forumPostService = forumPostService;
        this.userIntegrationService = userIntegrationService;
        this.scheduleService = scheduleService;
        this.firstPostLikeCallback = firstPostLikeCallback;
    }
}

