/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.process.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.ClientConfigProperties;
import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.create.process.impl.AbstractPostProcess;
import com.bxm.localnews.news.model.enums.SpecialForumEnum;
import com.bxm.localnews.news.model.param.PostProcessContext;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.util.PlaceHolderUtil;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NovicePostProcess
extends AbstractPostProcess {
    private static final Logger log = LoggerFactory.getLogger(NovicePostProcess.class);
    private final ClientConfigProperties clientConfigProperties;
    private final ForumPostService forumPostService;
    private final LocationIntegrationService locationIntegrationService;
    private final UserIntegrationService userIntegrationService;
    private static final String USER_NAME = "userName";
    private static final String AREA_NAME = "areaName";
    private static final AtomicReference<Long> NOVICE_TOPIC_ID = new AtomicReference();
    private final PostCreateService postCreateService;

    @Override
    protected Message doPost(PostProcessContext context) {
        LocationDTO locationDetailByCode = this.locationIntegrationService.getLocationByGeocode(context.getParam().getAreaCode());
        String locationName = Objects.isNull(locationDetailByCode) ? "" : locationDetailByCode.getName();
        UserBean userInfo = this.userIntegrationService.selectUserFromCache(context.getParam().getUserId());
        List<Object> postImg = Collections.emptyList();
        if (Objects.nonNull(userInfo)) {
            PostImgVo postImgVo = new PostImgVo();
            postImgVo.setType("IMG");
            postImgVo.setImgUrl(userInfo.getHeadImg());
            postImg = Collections.singletonList(postImgVo);
        }
        ForumBasicVo forumBasicVo = new ForumBasicVo();
        forumBasicVo.setAreaCode(context.getParam().getAreaCode());
        forumBasicVo.setTopicIdList(Collections.singletonList(this.getNoviceTopicId()));
        forumBasicVo.setIsNewReport(Byte.valueOf((byte)1));
        forumBasicVo.setTitle("");
        forumBasicVo.setUserId(context.getParam().getUserId());
        forumBasicVo.setLocation(locationName);
        forumBasicVo.setTextField(this.getPublishContent(userInfo, locationName));
        forumBasicVo.setPostImgList(postImg);
        log.info("\u7528\u6237: {} \u53d1\u9001\u65b0\u4eba\u5e16\u5b50\u4fe1\u606f: {}", (Object)context.getParam().getUserId(), (Object)JSON.toJSONString((Object)forumBasicVo));
        return this.postCreateService.saveUserPost(forumBasicVo, (BasicParam)context.getParam(), false);
    }

    private Long getNoviceTopicId() {
        if (Objects.isNull(NOVICE_TOPIC_ID.get())) {
            String newReport = this.clientConfigProperties.getNewReport();
            JSONObject jsonObject = JSON.parseObject((String)newReport);
            NOVICE_TOPIC_ID.set(jsonObject.getLong("id"));
        }
        return NOVICE_TOPIC_ID.get();
    }

    private String getPublishContent(UserBean userInfo, String locationName) {
        List publishContents;
        String publishContent = "\u65b0\u4eba\u62a5\u5230\uff0c\u6765\u6df7\u4e2a\u773c\u719f\uff0c\u4ee5\u540e\u6211\u4f1a\u7ecf\u5e38\u51fa\u73b0~";
        if (Objects.nonNull(this.clientConfigProperties.getPublishContent()) && Objects.nonNull(userInfo) && StringUtils.isNotBlank((CharSequence)locationName) && !CollectionUtils.isEmpty((Collection)(publishContents = JSON.parseArray((String)this.clientConfigProperties.getPublishContent(), String.class)))) {
            publishContent = (String)publishContents.get(RandomUtils.nextInt((int)0, (int)publishContents.size()));
            publishContent = this.replaceKeyWord(publishContent, userInfo.getNickname(), locationName);
        }
        return publishContent;
    }

    private String replaceKeyWord(String str, String userName, String areaName) {
        str = PlaceHolderUtil.replace((String)str, (String)AREA_NAME, (String)areaName, (String)areaName);
        return PlaceHolderUtil.replace((String)str, (String)USER_NAME, (String)userName, (String)userName);
    }

    @Override
    public SpecialForumEnum support() {
        return SpecialForumEnum.NOVICE;
    }

    public NovicePostProcess(ClientConfigProperties clientConfigProperties, ForumPostService forumPostService, LocationIntegrationService locationIntegrationService, UserIntegrationService userIntegrationService, PostCreateService postCreateService) {
        this.clientConfigProperties = clientConfigProperties;
        this.forumPostService = forumPostService;
        this.locationIntegrationService = locationIntegrationService;
        this.userIntegrationService = userIntegrationService;
        this.postCreateService = postCreateService;
    }
}

