/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.rule.IRule;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuleBean(group="ADMIN_POST_CREATE_RULE")
public class AdminPostAwardRule
implements IRule<AdminPostContext> {
    private static final Logger log = LoggerFactory.getLogger(AdminPostAwardRule.class);
    private final RedisStringAdapter redisStringAdapter;
    private final ForumPostShareCashInfoMapper postShareCashInfoMapper;

    public boolean apply(AdminPostContext adminPostContext) {
        AdminForumPost requestPost = adminPostContext.getRequestPost();
        AdminForumPost beforePost = adminPostContext.getBeforePost();
        if (Objects.equals(requestPost.getIsShareCash(), 0)) {
            return true;
        }
        Date awardStartTime = requestPost.getAwardStartTime();
        Date awardEndTime = requestPost.getAwardEndTime();
        if (Objects.nonNull(awardStartTime) && Objects.nonNull(awardEndTime) && DateUtils.after((Date)awardStartTime, (Date)awardEndTime)) {
            adminPostContext.setErrorMsg("\u70ed\u6587\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4");
            return false;
        }
        if (adminPostContext.isUpdatePost()) {
            BigDecimal remainingAmount;
            ForumPostShareCashInfoEntity shareCashInfoEntity = this.postShareCashInfoMapper.getByPostId(beforePost.getId());
            if (Objects.isNull(shareCashInfoEntity)) {
                return true;
            }
            beforePost.setAmount(shareCashInfoEntity.getAmount());
            BigDecimal changeAmount = requestPost.getAmount().subtract(beforePost.getAmount());
            if (changeAmount.compareTo(BigDecimal.ZERO) < 0 && (remainingAmount = (BigDecimal)this.redisStringAdapter.get(this.buildPostAwardKey(requestPost.getId()), BigDecimal.class)).doubleValue() < Math.abs(changeAmount.doubleValue())) {
                adminPostContext.setErrorMsg("\u70ed\u6587\u5206\u4eab\u5956\u91d1\u4e0d\u8db3");
                return false;
            }
        }
        return true;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    private KeyGenerator buildPostAwardKey(Long postId) {
        return RedisConfig.SHARE_POST_AWARD_KEY.copy().appendKey((Object)postId);
    }

    public AdminPostAwardRule(RedisStringAdapter redisStringAdapter, ForumPostShareCashInfoMapper postShareCashInfoMapper) {
        this.redisStringAdapter = redisStringAdapter;
        this.postShareCashInfoMapper = postShareCashInfoMapper;
    }
}

