/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuleBean(group="ADMIN_POST_CREATE_RULE")
public class AdminPostCheckRule
implements IRule<AdminPostContext> {
    private static final Logger log = LoggerFactory.getLogger(AdminPostCheckRule.class);
    private final ForumProperties forumProperties;

    public boolean apply(AdminPostContext context) {
        AdminForumPost adminForumPost = context.getRequestPost();
        if (null == adminForumPost.getId()) {
            context.setErrorMsg("ID\u672a\u4f20");
            return false;
        }
        BigDecimal cashReward = adminForumPost.getCashReward();
        if (log.isDebugEnabled()) {
            log.debug("\u73b0\u91d1\u53d1\u653e\u7684\u91d1\u989d\uff1a{}", (Object)cashReward);
        }
        if (cashReward != null) {
            int cash = cashReward.intValue();
            if (log.isDebugEnabled()) {
                log.debug("\u8fdb\u5165\u5224\u65ad\u8f6c\u5316\u4e3aint\u7c7b\u578b\uff1a{}", (Object)cash);
            }
            if (cash > this.forumProperties.getPostRewardCashMax()) {
                context.setErrorMsg("\u73b0\u91d1\u5956\u52b1\u6700\u5927" + this.forumProperties.getPostRewardCashMax() + "\u5143");
                return false;
            }
            if (cash < this.forumProperties.getPostRewardCashMin()) {
                context.setErrorMsg("\u73b0\u91d1\u5956\u52b1\u6700\u5c0f" + this.forumProperties.getPostRewardCashMin() + "\u5143");
                return false;
            }
        }
        if (DateUtils.before((Date)adminForumPost.getAwardStartTime(), (Date)adminForumPost.getPublishTime())) {
            context.setErrorMsg("\u70ed\u6587\u6709\u6548\u671f\u4e0d\u5f97\u5728\u53d1\u5e03\u65f6\u95f4\u4e4b\u524d");
            return false;
        }
        if (DateUtils.after((Date)adminForumPost.getAwardStartTime(), (Date)adminForumPost.getAwardEndTime())) {
            context.setErrorMsg("\u70ed\u6587\u6709\u6548\u671f\u622a\u6b62\u65f6\u95f4\u5728\u8d77\u59cb\u65f6\u95f4\u4e4b\u524d");
            return false;
        }
        return true;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public AdminPostCheckRule(ForumProperties forumProperties) {
        this.forumProperties = forumProperties;
    }
}

