/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.integration.SensitiveWordService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserNoteContext;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import com.bxm.newidea.component.tools.CharUtil;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuleBean(group="USER_NOTE_CREATE_RULE")
public class UserNoteCheckRule
implements IRule<UserNoteContext> {
    private static final Logger log = LoggerFactory.getLogger(UserNoteCheckRule.class);
    @Resource
    private SensitiveWordService sensitiveWordService;

    public boolean apply(UserNoteContext context) {
        NoteParam noteParam = context.getParam();
        if (null == noteParam || null == noteParam.getUserId() || StringUtils.isEmpty((String)noteParam.getTextField()) || null == noteParam.getValidDay()) {
            context.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
            return false;
        }
        if (StringUtils.isBlank((String)noteParam.getTextField())) {
            context.setErrorMsg("\u53d1\u5e03\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        if (CharUtil.getWordCount((String)noteParam.getTextField()) > 50) {
            context.setErrorMsg("\u53d1\u5e03\u5185\u5bb9\u8fc7\u957f");
            return false;
        }
        if (this.sensitiveWordService.contains(noteParam.getTextField())) {
            context.setErrorMsg("\u542b\u6709\u654f\u611f\u8bcd\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91");
            return false;
        }
        return true;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}

