/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import java.util.Objects;
import javax.annotation.Resource;

@RuleBean(group="USER_POST_CREATE_RULE")
public class UserPostNewbieRule
implements IRule<UserPostContext> {
    @Resource
    private ForumPostMapper forumPostMapper;

    public boolean apply(UserPostContext userPostContext) {
        if (userPostContext.isUpdatePost()) {
            userPostContext.setFirstUserPost(false);
        } else {
            boolean posted = this.forumPostMapper.selectPublishPostNumByUserId(userPostContext.getRequestPost().getUserId()) != 0;
            userPostContext.setFirstUserPost(!posted);
            if (Objects.equals(userPostContext.getRequestPost().getIsNewReport(), 1) && posted) {
                userPostContext.setErrorMsg("\u65b0\u4eba\u5e16\u5b50\u53ea\u53ef\u4ee5\u53d1\u9001\u4e00\u6b21\u54e6~");
                return false;
            }
        }
        return true;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}

