/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.HotForumPostVo;
import com.bxm.localnews.news.post.HotPostService;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import java.util.List;
import java.util.Objects;

@RuleBean(group="USER_POST_CREATE_RULE")
public class UserPostStatusCheckRule
implements IRule<UserPostContext> {
    private final HotPostService hotPostService;

    public boolean apply(UserPostContext userPostContext) {
        if (userPostContext.isUpdatePost()) {
            ForumBasicVo forumBasicVo = userPostContext.getRequestPost();
            if (Objects.nonNull(forumBasicVo.getAreaCode())) {
                List<HotForumPostVo> hotForumList = this.hotPostService.getHotForumList(forumBasicVo.getAreaCode());
                for (HotForumPostVo hotForumPostVo : hotForumList) {
                    if (!Objects.equals(hotForumPostVo.getId(), forumBasicVo.getId())) continue;
                    userPostContext.setErrorMsg("\u5e16\u5b50\u5df2\u4e0a\u70ed\u95e8\u5185\u5bb9\u699c\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u7f16\u8f91");
                    return false;
                }
            }
            if (Objects.equals(userPostContext.getBeforePost().getIsRecommend(), 1)) {
                userPostContext.setErrorMsg("\u60a8\u7684\u5185\u5bb9\u5df2\u88ab\u63a8\u8350\u5230\u5934\u6761\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u8054\u7cfb\u5ba2\u670d");
                return false;
            }
        }
        return true;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public UserPostStatusCheckRule(HotPostService hotPostService) {
        this.hotPostService = hotPostService;
    }
}

