/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.newidea.component.filter.IFilter;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostDetailFilter
implements IFilter<ForumPostDetailContext> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPostDetailFilter.class);
    @Resource
    private LocationIntegrationService locationIntegrationService;

    private boolean skipFilter(ForumPostDetailContext context) {
        if (context.getChoiceFilterList() != null) {
            return !context.getChoiceFilterList().contains(this.getClass());
        }
        if (null != context.getSkipFilterList()) {
            return context.getSkipFilterList().contains(this.getClass());
        }
        return false;
    }

    public void doFilter(ForumPostDetailContext context) {
        if (this.skipFilter(context)) {
            return;
        }
        String areaCode = context.getOriginalParam().getAreaCode();
        if (Objects.nonNull(context.getLocation())) {
            this.internalDoFilter(context);
        } else {
            if (StringUtils.isBlank((CharSequence)areaCode)) {
                context.setLocation(new LocationDTO());
            } else if (StringUtils.isNotBlank((CharSequence)areaCode) && context.getLocation() == null) {
                LocationDTO location = StringUtils.isNotEmpty((CharSequence)areaCode) ? this.locationIntegrationService.getLocationByGeocode(areaCode) : null;
                context.setLocation(location);
            }
            this.internalDoFilter(context);
        }
    }

    abstract void internalDoFilter(ForumPostDetailContext var1);

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}

