/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.activity.ActivityPostService;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.filter.AbstractPostDetailFilter;
import com.bxm.localnews.news.model.dto.activity.PostActivityExtendDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.annotations.FilterBean;
import java.util.Objects;
import javax.annotation.Resource;

@FilterBean(group="POST_DETAIL_FILTER")
public class ActivityPostFillFilter
extends AbstractPostDetailFilter {
    @Resource
    private ActivityPostService activityPostService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        if (Objects.equals(forumPostVo.getActivityPost(), 1)) {
            ForumPostActivityEntity detail = this.activityPostService.getDetail(forumPostVo.getId());
            String protocol = detail.getProtocol();
            if (context.isOutSide() && detail.getGoodsId() != null) {
                LocationDTO locationDTO = context.getLocation();
                protocol = ProtocolFactory.goods().outer().goodsId(detail.getGoodsId()).areaCode(locationDTO.getCode()).areaName(locationDTO.getName()).inviterId(context.getUserId()).build();
            }
            int status = Objects.equals(detail.getStatus(), 1) ? 1 : 2;
            forumPostVo.setPostActivityExtendDTO(PostActivityExtendDTO.builder().activityStatus(Integer.valueOf(status)).joinText(detail.getJoinText()).protocolUrl(protocol).build());
        }
    }
}

