/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.filter.AbstractPostDetailFilter;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@FilterBean(group="POST_DETAIL_FILTER")
public class BaseInfoFillFilter
extends AbstractPostDetailFilter {
    @Resource
    private IUrlFactory iUrlFactory;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        if (StringUtils.isBlank((CharSequence)forumPostVo.getLocation())) {
            LocationDTO locationDTO = context.getLocation();
            forumPostVo.setLocation(null != locationDTO ? locationDTO.getName() : null);
        }
        forumPostVo.setTextField(StringUtils.isNotBlank((CharSequence)forumPostVo.getTextField()) ? StringEscapeUtils.unescapeHtml((String)forumPostVo.getTextField()) : null);
        forumPostVo.setContent(StringUtils.isNotBlank((CharSequence)forumPostVo.getContent()) ? StringEscapeUtils.unescapeHtml((String)forumPostVo.getContent()) : null);
        forumPostVo.setDisplayTime(null != forumPostVo.getDisplayDateTime() ? DateUtils.timeConvertString((Date)forumPostVo.getDisplayDateTime()) : null);
        forumPostVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), context.getUserId()));
        forumPostVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), context.getUserId()));
    }
}

