/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.comment.service.CommentFacadeService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.filter.AbstractPostDetailFilter;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import java.util.Objects;

@FilterBean(group="POST_DETAIL_FILTER")
public class CommentCalFilter
extends AbstractPostDetailFilter {
    private CommentFacadeService commentFacadeService;
    private ForumProperties forumProperties;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        if (!this.forumProperties.getEnableAccurateCommentNum().booleanValue()) {
            return;
        }
        LocationDTO locationDTO = context.getLocation();
        if (Objects.nonNull(locationDTO)) {
            ForumPostVo forumPostVo = context.getPostInfo();
            forumPostVo.setCommentCount(this.commentFacadeService.replyNum(forumPostVo.getId(), context.getUserId(), locationDTO.getCode()));
        }
    }

    public CommentCalFilter(CommentFacadeService commentFacadeService, ForumProperties forumProperties) {
        this.commentFacadeService = commentFacadeService;
        this.forumProperties = forumProperties;
    }
}

