/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.integration.VoteIntegrationService;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.filter.AbstractPostDetailFilter;
import com.bxm.localnews.news.model.vo.ForumPlugin;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.param.VotePinParam;
import com.bxm.newidea.component.annotations.FilterBean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="POST_DETAIL_FILTER")
public class PluginLoadFilter
extends AbstractPostDetailFilter {
    private static final Logger log = LoggerFactory.getLogger(PluginLoadFilter.class);
    @Resource
    private VoteIntegrationService voteIntegrationService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        if (log.isDebugEnabled()) {
            log.debug("forumpost:[{}],plugins:[{}]", (Object)forumPostVo.getId(), (Object)forumPostVo.getPlugins());
        }
        if (forumPostVo.getPlugins() != null) {
            for (ForumPlugin plugin : forumPostVo.getPlugins()) {
                if (!"VOTE".equals(plugin.getType())) continue;
                VotePinParam param = new VotePinParam();
                param.setRelationId(forumPostVo.getId());
                param.setVoteId(plugin.getId());
                param.setUserId(context.getUserId());
                forumPostVo.setVoteDetailDTO(this.voteIntegrationService.get(param));
                break;
            }
        }
    }
}

