/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.filter.AbstractPostDetailFilter;
import com.bxm.localnews.news.hotpost.ShareCashPostService;
import com.bxm.localnews.news.model.dto.hotpost.ShareCashExtendDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;

@FilterBean(group="POST_DETAIL_FILTER")
public class ShareCashPostFillFilter
extends AbstractPostDetailFilter {
    @Resource
    private ShareCashPostService shareCashPostService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        if (Objects.equals(forumPostVo.getShareCash(), 1)) {
            ForumPostShareCashInfoEntity detail = this.shareCashPostService.getDetail(forumPostVo.getId());
            if (detail.getStatus() == 0) {
                return;
            }
            BigDecimal usedAmount = BigDecimal.ZERO;
            if (context.getPostInfo().getShareCount() > 0) {
                BigDecimal randomAmount = (BigDecimal)this.redisHashMapAdapter.get(this.buildHotPostRandomAwardKey(), String.valueOf(context.getPostId()), BigDecimal.class);
                usedAmount = detail.getUsedAmount().multiply(BigDecimal.valueOf(2L));
                usedAmount = usedAmount.add(randomAmount);
            }
            forumPostVo.setShareCashExtendDTO(ShareCashExtendDTO.builder().amount(detail.getAmount()).usedAmount(usedAmount).build());
        }
    }

    private KeyGenerator buildHotPostRandomAwardKey() {
        return RedisConfig.HOT_POST_INIT_RANDOM_AWARD_KEY.copy();
    }
}

