/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.news.config.LotteryFlauntForumProperties;
import com.bxm.localnews.news.content.replace.html.LotteryFlauntJumpUrlReplace;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.filter.AbstractPostDetailFilter;
import com.bxm.localnews.news.model.vo.ExtJumpInfo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.annotations.FilterBean;
import java.util.List;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@FilterBean(group="POST_DETAIL_FILTER")
public class TopicFillFilter
extends AbstractPostDetailFilter {
    private ForumTopicService forumTopicService;
    private LotteryFlauntForumProperties lotteryFlauntForumProperties;
    private DomainIntegrationService domainIntegrationService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        List<TopicVo> topicVoList = this.forumTopicService.loadTopicByIds(forumPostVo.getTopicIds(), context.getLocation(), context.getUserId());
        for (TopicVo topicVo : topicVoList) {
            topicVo.setShareUrl(ProtocolFactory.topic().outer().userId(context.getOriginalParam().getUserId()).topicId(topicVo.getId()).areaCode(context.getAreaCode()).build());
            if (!Objects.equals(topicVo.getId(), this.lotteryFlauntForumProperties.getLotteryFlauntTopicId())) continue;
            this.setJumpInfo(forumPostVo);
        }
        forumPostVo.setTopicList(topicVoList);
    }

    private void setJumpInfo(ForumPostVo forumPostVo) {
        Document document = Jsoup.parse((String)forumPostVo.getContent());
        if (Objects.nonNull(document) && !document.select(LotteryFlauntJumpUrlReplace.LOTTERY_FLAUNT_JUMP_URL_SELECT).isEmpty()) {
            ExtJumpInfo jumpInfo = new ExtJumpInfo();
            jumpInfo.setText(this.lotteryFlauntForumProperties.getForumText());
            jumpInfo.setJumpUrl(this.domainIntegrationService.getInnerH5BaseUrl() + this.lotteryFlauntForumProperties.getForumJumpUrl());
            forumPostVo.setExtJumpInfo(jumpInfo);
        }
    }

    public TopicFillFilter(ForumTopicService forumTopicService, LotteryFlauntForumProperties lotteryFlauntForumProperties, DomainIntegrationService domainIntegrationService) {
        this.forumTopicService = forumTopicService;
        this.lotteryFlauntForumProperties = lotteryFlauntForumProperties;
        this.domainIntegrationService = domainIntegrationService;
    }
}

