/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.impl;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.action.PostClickService;
import com.bxm.localnews.news.detail.ForumPostDetailService;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.context.PostDetailOriginalParam;
import com.bxm.localnews.news.detail.filter.ActivityPostFillFilter;
import com.bxm.localnews.news.detail.filter.CollectFillFilter;
import com.bxm.localnews.news.detail.filter.CommentCalFilter;
import com.bxm.localnews.news.detail.filter.ContentAssemblyFilter;
import com.bxm.localnews.news.detail.filter.HotReplayFillFilter;
import com.bxm.localnews.news.detail.filter.LikeFillFilter;
import com.bxm.localnews.news.detail.filter.PluginLoadFilter;
import com.bxm.localnews.news.detail.filter.RelationFillFilter;
import com.bxm.localnews.news.detail.filter.ShareCashPostFillFilter;
import com.bxm.localnews.news.detail.filter.TopicFillFilter;
import com.bxm.localnews.news.detail.filter.VestTypeFillFilter;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.filter.FilterChainExecutor;
import com.bxm.newidea.component.rule.RuleGroupExecutor;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ForumPostDetailServiceImpl
implements ForumPostDetailService {
    private static final Logger log = LoggerFactory.getLogger(ForumPostDetailServiceImpl.class);
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private RuleGroupExecutor ruleGroupExecutor;
    @Resource
    private FilterChainExecutor filterChainExecutor;
    @Resource
    private PostClickService postClickService;

    @Override
    public ForumPostVo get(PostDetailOriginalParam param) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u5e16\u5b50\u8be6\u60c5\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        }
        Preconditions.checkArgument((null != param && null != param.getId() ? 1 : 0) != 0);
        ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(param.getId());
        if (null != forumPostVo) {
            ForumPostDetailContext context = new ForumPostDetailContext(param);
            context.setPostInfo(forumPostVo);
            context.skipFilter(HotReplayFillFilter.class);
            if (!this.ruleGroupExecutor.apply("POST_DETAIL_RULE", (Object)context)) {
                return context.getPostInfo();
            }
            this.filterChainExecutor.parallelDoFilter("POST_DETAIL_FILTER", (Object)context);
            if (null != param.getBasicParam()) {
                this.postClickService.doAsyncReadPost(context.getUserId(), context.getPostId(), param.getShareUserId(), param.getBasicParam().getPlatform(), forumPostVo, param.getIp());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5e16\u5b50[{}]\u83b7\u53d6\u8017\u65f6:{}", (Object)param.getId(), (Object)(System.currentTimeMillis() - start));
        }
        return forumPostVo;
    }

    @Override
    public ForumPostVo get(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(context.getPostId());
        if (context.getOriginalParam().getBasicParam() == null) {
            context.getOriginalParam().setBasicParam(new BasicParam());
        }
        context.setPostInfo(forumPostVo);
        context.skipFilter(HotReplayFillFilter.class);
        this.filterChainExecutor.doFilter("POST_DETAIL_FILTER", (Object)context);
        return forumPostVo;
    }

    @Override
    public ForumPostVo getBriefPost(Long postId, Long userId, String areaCode) {
        ForumPostVo forumPostVo = this.forumPostMapper.selectWithoutContent(postId);
        PostDetailOriginalParam param = new PostDetailOriginalParam();
        param.setId(postId);
        param.setUserId(userId);
        param.setAreaCode(areaCode);
        ForumPostDetailContext context = new ForumPostDetailContext(param);
        context.setPostInfo(forumPostVo);
        context.skipFilter(LikeFillFilter.class).skipFilter(CollectFillFilter.class).skipFilter(RelationFillFilter.class).skipFilter(TopicFillFilter.class).skipFilter(PluginLoadFilter.class).skipFilter(ContentAssemblyFilter.class).skipFilter(HotReplayFillFilter.class).skipFilter(VestTypeFillFilter.class).skipFilter(ActivityPostFillFilter.class).skipFilter(ShareCashPostFillFilter.class).skipFilter(CommentCalFilter.class);
        this.filterChainExecutor.doFilter("POST_DETAIL_FILTER", (Object)context);
        return forumPostVo;
    }
}

