/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.rule;

import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.rule.IRule;
import java.util.Objects;
import javax.annotation.Resource;

@RuleBean(group="POST_DETAIL_RULE")
public class ViewLimitRule
implements IRule<ForumPostDetailContext> {
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private HyperLogLogAdapter hyperLogLogAdapter;

    public boolean apply(ForumPostDetailContext context) {
        KeyGenerator keyGenerator;
        Long recordNum;
        if (!context.isOutSide()) {
            return true;
        }
        if (Objects.equals(PostStatusEnum.APPROVING.getCode(), context.getPostInfo().getStatus()) && null != (recordNum = this.hyperLogLogAdapter.size(new KeyGenerator[]{keyGenerator = RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey((Object)context.getPostId())})) && recordNum >= (long)this.forumProperties.getH5LimitNum().intValue()) {
            context.setEmptyPost();
            return false;
        }
        return true;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}

