/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.forum.impl;

import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.AdminAreaRelationMapper;
import com.bxm.localnews.news.domain.AdminForumMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.forum.AdminForumService;
import com.bxm.localnews.news.model.dto.AdminAreaRelationDTO;
import com.bxm.localnews.news.model.param.AdminForumParam;
import com.bxm.localnews.news.model.param.AdminForumUpdateParam;
import com.bxm.localnews.news.model.vo.AdminForum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminForumServiceImpl
implements AdminForumService {
    @Resource
    private AdminForumMapper adminForumMapper;
    @Resource
    private AdminAreaRelationMapper adminAreaRelationMapper;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private AdminForumPostMapper adminForumPostMapper;

    @Override
    public PageWarper<AdminForum> getList(AdminForumParam param) {
        PageWarper forumList = new PageWarper(this.adminForumMapper.getList(param));
        if (CollectionUtils.isNotEmpty((Collection)forumList.getList())) {
            for (AdminForum adminForum : forumList.getList()) {
                this.completeForum(adminForum);
            }
        }
        return forumList;
    }

    @Override
    public AdminForum selectByPrimaryKey(Long id) {
        AdminForum adminForum = this.adminForumMapper.selectByPrimaryKey(id);
        this.completeForum(adminForum);
        return adminForum;
    }

    @Override
    public int updateStatus(Long id, Byte status) {
        AdminForum adminForum = this.adminForumMapper.selectByPrimaryKey(id);
        if (adminForum == null) {
            return 0;
        }
        adminForum.setEnable(status);
        this.adminForumMapper.updateByPrimaryKeySelective(adminForum);
        this.removeCache();
        return 1;
    }

    @Override
    public int saveOrUpdate(AdminForum adminForum) {
        int update;
        Long id = adminForum.getId();
        if (null == id) {
            id = this.sequenceCreater.nextLongId();
            adminForum.setId(id);
            adminForum.setCreateTime(new Date());
            update = this.adminForumMapper.insert(adminForum);
        } else {
            update = this.adminForumMapper.updateByPrimaryKeySelective(adminForum);
        }
        this.adminAreaRelationMapper.batchDelete(adminForum.getId(), Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)adminForum.getAreaCodes())) {
            ArrayList<AdminAreaRelationDTO> list = new ArrayList<AdminAreaRelationDTO>();
            for (String areaCode : adminForum.getAreaCodes()) {
                AdminAreaRelationDTO adminAreaRelationDTO = new AdminAreaRelationDTO();
                adminAreaRelationDTO.setId(this.sequenceCreater.nextLongId());
                adminAreaRelationDTO.setRelationId(adminForum.getId());
                adminAreaRelationDTO.setAreaCode(areaCode);
                adminAreaRelationDTO.setType(Byte.valueOf((byte)1));
                list.add(adminAreaRelationDTO);
            }
            this.adminAreaRelationMapper.batchInsert(list);
        }
        this.removeCache();
        return update;
    }

    @Override
    public int updateOrder(Long id, Integer order) {
        AdminForum adminForum = this.adminForumMapper.selectByPrimaryKey(id);
        if (adminForum == null) {
            return 0;
        }
        adminForum.setOrder(order);
        this.adminForumMapper.updateByPrimaryKeySelective(adminForum);
        this.removeCache();
        return 1;
    }

    @Override
    public List<AdminForum> getSimpleList(String key) {
        AdminForumParam param = new AdminForumParam();
        param.setTitle(key);
        param.setPageSize(Integer.valueOf(0));
        return this.adminForumMapper.getList(param);
    }

    @Override
    public void updatePostForum(AdminForumUpdateParam adminForumUpdateParam) {
        this.adminForumMapper.updatePostForum(adminForumUpdateParam);
    }

    private void completeForum(AdminForum adminForum) {
        if (adminForum != null) {
            adminForum.setAreaCodes(this.adminAreaRelationMapper.getAreaCodes(adminForum.getId(), Integer.valueOf(1)));
            adminForum.setAreas(this.locationIntegrationService.batchFetch(adminForum.getAreaCodes()));
        }
    }

    private KeyGenerator getKey() {
        return RedisConfig.FORUM.copy();
    }

    private void removeCache() {
        this.redisHashMapAdapter.remove(this.getKey());
    }
}

