/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.forum.impl;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumMapper;
import com.bxm.localnews.news.dto.RelationDTO;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.forum.ForumService;
import com.bxm.localnews.news.model.vo.ForumVo;
import com.bxm.localnews.news.model.vo.PostForumVO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ForumServiceImpl
extends BaseService
implements ForumService {
    @Resource
    private ForumMapper forumMapper;
    @Resource
    private IUrlFactory iUrlFactory;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private RedisListAdapter redisListAdapter;

    @Override
    public List<PostForumVO> listForumByPostId(List<Long> postIds, Long userId) {
        ArrayList<PostForumVO> postForumVoList = new ArrayList<PostForumVO>();
        List relationList = this.forumMapper.getPostForumRelation(postIds);
        if (CollectionUtils.isNotEmpty((Collection)relationList)) {
            for (RelationDTO relation : relationList) {
                ForumVo forumVo;
                PostForumVO postForum = new PostForumVO();
                postForum.setPostId(relation.getAid());
                if (null != relation.getBid() && null != (forumVo = this.getForumPost(relation.getBid(), userId))) {
                    BeanUtils.copyProperties((Object)forumVo, (Object)postForum);
                }
                postForumVoList.add(postForum);
            }
        }
        return postForumVoList;
    }

    @Override
    public void fillForumShareInfo(ForumVo forumVo, Long userId) {
        if (forumVo != null) {
            forumVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, forumVo.getId(), userId));
            forumVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.BLOCK, forumVo.getId(), userId));
        }
    }

    @Override
    public ForumVo getForumPost(Long forumId, Long userId) {
        ForumVo forumVo = this.getForumById(forumId, null);
        this.fillForumShareInfo(forumVo, userId);
        return forumVo;
    }

    @Override
    public List<ForumVo> listForum(String areaCode, Integer size, Long userId, BasicParam basicParam) {
        List<Object> forumVoList = this.getForumList(areaCode);
        if (CollectionUtils.isNotEmpty(forumVoList)) {
            if (null != userId) {
                this.sortForm(forumVoList, userId);
                forumVoList = forumVoList.stream().distinct().collect(Collectors.toList());
            }
            if (size != null) {
                forumVoList = forumVoList.stream().limit(size.intValue()).collect(Collectors.toList());
            }
            forumVoList = this.filterForum(forumVoList, basicParam);
            forumVoList.forEach(e -> this.fillForumShareInfo((ForumVo)e, userId));
        }
        return forumVoList;
    }

    @Override
    public void updateForum(Long forumId, Long userId) {
        List<Object> ids = new ArrayList<Long>();
        ids.add(forumId);
        KeyGenerator forumKey = RedisConfig.FORUM_INFO.copy().appendKey((Object)userId).appendKey((Object)"forum").appendKey((Object)"recent");
        if (this.redisListAdapter.size(forumKey) > 0L) {
            List forumList = this.redisListAdapter.leftIndex(forumKey, this.redisListAdapter.size(forumKey).longValue(), Long.class);
            ids.addAll(forumList);
        }
        ids = ids.stream().distinct().collect(Collectors.toList());
        this.logger.debug("\u6839\u636eid\u8fdb\u5165\u677f\u5757\u8be6\u60c5\u83b7\u53d6\u63a8\u8350\u6d41\u66f4\u65b0\u677f\u5757\u987a\u5e8f,id:{},userId:{},redisKey:{}", new Object[]{forumId, userId, forumKey.gen()});
        this.redisListAdapter.remove(forumKey);
        this.redisListAdapter.rightPush(forumKey, (Object[])ids.toArray(new Long[0]));
        this.redisListAdapter.expire(forumKey, 259200L);
    }

    @Override
    public ForumVo getForumDetail(Long id, Long userId, String areaCode) {
        ForumVo forumVo = this.getForumById(id, areaCode);
        if (null != forumVo) {
            this.updateForum(id, userId);
        }
        this.fillForumShareInfo(forumVo, userId);
        return forumVo;
    }

    private ForumVo getForumById(Long id, String areaCode) {
        List<ForumVo> forumVoList = this.getForumList(areaCode);
        if (CollectionUtils.isNotEmpty(forumVoList)) {
            for (ForumVo forumVo : forumVoList) {
                if (!forumVo.getId().equals(id)) continue;
                return forumVo;
            }
        }
        return this.forumMapper.selectForumById(id, areaCode);
    }

    private List<ForumVo> getForumList(String areaCode) {
        List forumVoList;
        String areaCodeKey = areaCode;
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCodeKey = "0";
        }
        if (CollectionUtils.isEmpty((Collection)(forumVoList = (List)this.redisHashMapAdapter.get(RedisConfig.FORUM.copy(), areaCodeKey, (TypeReference)new TypeReference<List<ForumVo>>(){}))) && CollectionUtils.isNotEmpty((Collection)(forumVoList = this.forumMapper.getForumList(areaCode, Integer.valueOf(1))))) {
            this.redisHashMapAdapter.put(RedisConfig.FORUM.copy(), areaCodeKey, (Object)forumVoList);
        }
        return forumVoList;
    }

    private void sortForm(List<ForumVo> forumVoList, Long userId) {
        List forumList;
        KeyGenerator forumKey = RedisConfig.FORUM_INFO.copy().appendKey((Object)userId).appendKey((Object)"forum").appendKey((Object)"recent");
        if (this.redisListAdapter.size(forumKey) > 0L && CollectionUtils.isNotEmpty((Collection)(forumList = this.redisListAdapter.leftIndex(forumKey, this.redisListAdapter.size(forumKey).longValue(), Long.class)))) {
            ArrayList<ForumVo> existence = new ArrayList<ForumVo>();
            for (Long id : forumList) {
                for (ForumVo forumVo : forumVoList) {
                    if (!forumVo.getId().equals(id)) continue;
                    existence.add(forumVo);
                }
            }
            if (forumVoList.size() >= 2) {
                forumVoList.addAll(2, existence);
            } else {
                forumVoList.addAll(existence);
            }
        }
    }

    private List<ForumVo> filterForum(List<ForumVo> forumVoList, BasicParam basicParam) {
        if (5 == basicParam.getPlatform() && this.bizConfigProperties.getAppletReviewEnable().booleanValue()) {
            ImmutableList postIds = ImmutableList.of((Object)72317665317008L, (Object)79585788760192L, (Object)80775388106880L, (Object)81892185086080L, (Object)77973991071872L, (Object)80669901684864L, (Object)79211746459776L, (Object)79211241126016L);
            return forumVoList.stream().filter(arg_0 -> ForumServiceImpl.lambda$filterForum$1((List)postIds, arg_0)).collect(Collectors.toList());
        }
        return forumVoList;
    }

    private static /* synthetic */ boolean lambda$filterForum$1(List postIds, ForumVo e) {
        return !postIds.contains(e.getId());
    }
}

