/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.filter.support;

import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class HotPostStatusFilter
implements IHotPostCashFilter {
    private final ForumPostMapper forumPostMapper;
    private final ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;

    @Override
    public Message handle(HotPostShareContext shareContext) {
        Long postId = shareContext.getPostId();
        boolean existHotPost = this.forumPostMapper.existHotPost(postId);
        if (Boolean.FALSE.equals(existHotPost)) {
            return Message.build((boolean)false, (String)"\u70ed\u6587\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548");
        }
        ForumPostShareCashInfoEntity sharePostInfo = this.forumPostShareCashInfoMapper.getByPostId(postId);
        if (Objects.isNull(sharePostInfo)) {
            return Message.build((boolean)false, (String)"\u70ed\u6587\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (sharePostInfo.getStatus() == 0) {
            return Message.build((boolean)false, (String)"\u70ed\u6587\u5df2\u5931\u6548");
        }
        return Message.build((boolean)true);
    }

    public HotPostStatusFilter(ForumPostMapper forumPostMapper, ForumPostShareCashInfoMapper forumPostShareCashInfoMapper) {
        this.forumPostMapper = forumPostMapper;
        this.forumPostShareCashInfoMapper = forumPostShareCashInfoMapper;
    }
}

