/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.filter.support;

import com.bxm.localnews.common.vo.IP;
import com.bxm.localnews.dto.LocationProvinceAndCityDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.util.IPConvertUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class IpFilter
implements IHotPostCashFilter {
    private static final Logger log = LoggerFactory.getLogger(IpFilter.class);
    private UserIntegrationService userIntegrationService;
    private LocationIntegrationService locationIntegrationService;

    @Override
    public Message handle(HotPostShareContext shareContext) {
        UserBean shareUser = this.userIntegrationService.selectUserFromCache(shareContext.getShareUserId());
        if (null == shareUser) {
            return Message.build((boolean)false, (String)"\u5206\u4eab\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String loginIp = shareContext.getIp();
        IP ipInfo = IPConvertUtil.find(loginIp);
        if (null == ipInfo) {
            log.info("IP:[{}]\u4e0d\u5b58\u5728\u4e8eIP\u5e93", (Object)shareContext.getIp());
            return Message.build((boolean)false, (String)"Ip\u4e0d\u5b58\u5728ip\u5e93");
        }
        LocationProvinceAndCityDTO provinceAndCityInfo = this.locationIntegrationService.getProvinceAndCityInfo(shareContext.getAreaCode());
        if (Objects.isNull(provinceAndCityInfo)) {
            return Message.build((boolean)false, (String)"\u5206\u4eab\u8005\u7684areaCode\u4fe1\u606f\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u7701\u5e02\u4fe1\u606f");
        }
        String cityName = provinceAndCityInfo.getCity();
        String provinceName = provinceAndCityInfo.getProvince();
        if (StringUtils.isNotBlank((CharSequence)cityName)) {
            cityName = cityName.replace("\u5e02", "");
        }
        if (StringUtils.isNotBlank((CharSequence)provinceName)) {
            provinceName = provinceName.replace("\u7701", "");
        }
        if (StringUtils.isNotBlank((CharSequence)cityName) && com.bxm.newidea.component.tools.StringUtils.equals((CharSequence)cityName, (CharSequence)ipInfo.getCity())) {
            return Message.build((boolean)true);
        }
        if (StringUtils.isNotBlank((CharSequence)provinceName) && com.bxm.newidea.component.tools.StringUtils.equals((CharSequence)provinceName, (CharSequence)ipInfo.getProvince())) {
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false, (String)("\u4e0d\u5728\u6307\u5b9a\u533a\u57df\uff0cip\u767b\u5f55\u7701\u4efd\uff1a" + ipInfo.getProvince() + ",ip\u767b\u5f55\u57ce\u5e02\uff1a" + ipInfo.getCity() + "\u5206\u4eab\u7528\u6237\u7701\u4efd\uff1a" + provinceAndCityInfo.getProvince() + ",\u5206\u4eab\u7528\u6237\u57ce\u5e02\uff1a" + provinceAndCityInfo.getCity()));
    }

    public IpFilter(UserIntegrationService userIntegrationService, LocationIntegrationService locationIntegrationService) {
        this.userIntegrationService = userIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
    }
}

