/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.filter.support;

import com.bxm.localnews.news.config.SharePostCashProperties;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashCounterMapper;
import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashCounterEntity;
import com.bxm.newidea.component.vo.Message;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class UserShareStatusFilter
implements IHotPostCashFilter {
    private final ForumPostShareCashCounterMapper forumPostShareCashCounterMapper;
    private final SharePostCashProperties sharePostCashProperties;

    @Override
    public Message handle(HotPostShareContext shareContext) {
        Long shareUserId = shareContext.getShareUserId();
        ForumPostShareCashCounterEntity counterEntity = this.forumPostShareCashCounterMapper.selectByDateAndUserId(shareUserId, this.getCurrentDateStr());
        if (Objects.isNull(counterEntity)) {
            return Message.build((boolean)true);
        }
        if (counterEntity.getAwardAmount().compareTo(this.sharePostCashProperties.getLimitAward()) >= 0) {
            return Message.build((boolean)false, (String)"\u7528\u6237\u5df2\u7ecf\u8fbe\u5230\u4eca\u65e5\u70ed\u6587\u5956\u52b1\u4e0a\u9650");
        }
        return Message.build((boolean)true);
    }

    private String getCurrentDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public UserShareStatusFilter(ForumPostShareCashCounterMapper forumPostShareCashCounterMapper, SharePostCashProperties sharePostCashProperties) {
        this.forumPostShareCashCounterMapper = forumPostShareCashCounterMapper;
        this.sharePostCashProperties = sharePostCashProperties;
    }
}

