/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.impl;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.activity.ForumPostActivityMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.hotpost.HotPostBulletService;
import com.bxm.localnews.news.model.dto.PostBarrageContentDTO;
import com.bxm.localnews.news.model.dto.PostBarrageDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.param.activity.PostDetailBarrageParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.hotpost.HotPostBulletVO;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HotPostBulletServiceImpl
implements HotPostBulletService {
    private static final Logger log = LoggerFactory.getLogger(HotPostBulletServiceImpl.class);
    private final UserIntegrationService userIntegrationService;
    private final ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;
    private final ForumPostActivityMapper forumPostActivityMapper;
    private final ForumPostMapper forumPostMapper;
    private final RedisSetAdapter redisSetAdapter;
    private static final int BULLET_USER_NUM = 10;

    @Override
    public PostBarrageDTO getPostBarrage(PostDetailBarrageParam param) {
        PostBarrageDTO resultDTO = new PostBarrageDTO();
        ForumPostVo forumPostVo = this.forumPostMapper.selectWithoutContent(param.getPostId());
        ForumPostActivityEntity forumPostActivityEntity = this.forumPostActivityMapper.selectByPostId(param.getPostId());
        if (Objects.equals(forumPostVo.getActivityPost(), 0) || Objects.isNull(forumPostActivityEntity) || Objects.equals(forumPostActivityEntity.getStatus(), 0)) {
            resultDTO.setContentList(Collections.emptyList());
            resultDTO.setBulletType(Integer.valueOf(1));
            return resultDTO;
        }
        if (param.getPlatform() == PlatformEnum.WEB.getCode()) {
            this.buildActivityBarrage(param.getPostId(), resultDTO);
            return resultDTO;
        }
        ForumPostShareCashInfoEntity postShareCashInfoEntity = this.forumPostShareCashInfoMapper.getByPostId(param.getPostId());
        if (Objects.equals(forumPostVo.getShareCash(), 1) && Objects.nonNull(postShareCashInfoEntity) && Objects.equals(postShareCashInfoEntity.getStatus(), 1)) {
            this.buildSharePostBarrage(resultDTO, forumPostVo.getShareCount());
        } else {
            this.buildActivityBarrage(param.getPostId(), resultDTO);
        }
        return resultDTO;
    }

    private void buildActivityBarrage(Long postId, PostBarrageDTO resultDTO) {
        resultDTO.setBulletType(Integer.valueOf(1));
        Set joinActivityUsers = this.redisSetAdapter.getAllMembers(this.buildJoinActivityUserKey(postId), Long.class);
        if (joinActivityUsers.size() < 3) {
            resultDTO.setContentList(Collections.emptyList());
            return;
        }
        List contentList = joinActivityUsers.stream().limit(10L).map(userId -> {
            UserBean userCache = this.userIntegrationService.selectUserFromCache(userId);
            PostBarrageContentDTO contentDTO = new PostBarrageContentDTO();
            contentDTO.setUserId(userId);
            contentDTO.setHeadImg(userCache.getHeadImg());
            contentDTO.setNickName(this.retentionFiveLength(userCache.getNickname()));
            return contentDTO;
        }).collect(Collectors.toList());
        resultDTO.setContentList(contentList);
    }

    @Override
    public List<HotPostBulletVO> shareHotPostBullet(String areaCode) {
        List virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(10));
        ArrayList<HotPostBulletVO> resultList = new ArrayList<HotPostBulletVO>();
        virtualUserList.forEach(u -> {
            HotPostBulletVO bulletItemVO = new HotPostBulletVO();
            BeanUtils.copyProperties((Object)u, (Object)bulletItemVO);
            bulletItemVO.setUserId(u.getId());
            resultList.add(bulletItemVO);
        });
        return resultList;
    }

    private void buildSharePostBarrage(PostBarrageDTO resultDTO, Integer shareCount) {
        resultDTO.setBulletType(Integer.valueOf(0));
        if (shareCount < 10) {
            resultDTO.setContentList(Collections.emptyList());
            return;
        }
        List virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(10));
        List contentList = virtualUserList.stream().map(virtualUserInfo -> {
            PostBarrageContentDTO contentDTO = new PostBarrageContentDTO();
            contentDTO.setNickName(this.retentionFiveLength(virtualUserInfo.getNickname()));
            contentDTO.setHeadImg(virtualUserInfo.getHeadImg());
            contentDTO.setUserId(virtualUserInfo.getId());
            contentDTO.setAwardAmount(BigDecimal.valueOf(RandomUtils.randomDouble((int)2, (double)0.3, (double)3.0)));
            return contentDTO;
        }).collect(Collectors.toList());
        resultDTO.setContentList(contentList);
    }

    private KeyGenerator buildJoinActivityUserKey(Long postId) {
        return RedisConfig.ACTIVITY_POST_JOIN_USER_KEY.copy().appendKey((Object)postId);
    }

    private String retentionFiveLength(String sourceNickname) {
        if (StringUtils.isNotBlank((CharSequence)sourceNickname)) {
            if (sourceNickname.length() > 5) {
                return sourceNickname.substring(0, 5) + "...";
            }
            return sourceNickname;
        }
        return "";
    }

    public HotPostBulletServiceImpl(UserIntegrationService userIntegrationService, ForumPostShareCashInfoMapper forumPostShareCashInfoMapper, ForumPostActivityMapper forumPostActivityMapper, ForumPostMapper forumPostMapper, RedisSetAdapter redisSetAdapter) {
        this.userIntegrationService = userIntegrationService;
        this.forumPostShareCashInfoMapper = forumPostShareCashInfoMapper;
        this.forumPostActivityMapper = forumPostActivityMapper;
        this.forumPostMapper = forumPostMapper;
        this.redisSetAdapter = redisSetAdapter;
    }
}

