/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.config.H5JumpAddressProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashCounterMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashRecordMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashSingleCountMapper;
import com.bxm.localnews.news.enums.HotPostCashSettlementStatusEnum;
import com.bxm.localnews.news.enums.HotPostShareRecordStatusEnum;
import com.bxm.localnews.news.hotpost.HotPostSettlementService;
import com.bxm.localnews.news.hotpost.filter.chain.HotPostCashFilterChain;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashCounterEntity;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashRecordEntity;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashSingleCountEntity;
import com.bxm.localnews.news.model.param.CashAccountParam;
import com.bxm.localnews.news.model.param.EarningsSaveOrUpdateParam;
import com.bxm.localnews.news.model.vo.hotpost.HotPostReadDataDTO;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.localnews.user.enums.UserEarningsTypeEnum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HotPostSettlementServiceImpl
implements HotPostSettlementService {
    private static final Logger log = LoggerFactory.getLogger(HotPostSettlementServiceImpl.class);
    private final HotPostCashFilterChain hotPostCashFilterChain;
    private final RedisStringAdapter redisStringAdapter;
    private final ForumPostShareCashRecordMapper forumPostShareCashRecordMapper;
    private final ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;
    private final ForumPostShareCashCounterMapper forumPostShareCashCounterMapper;
    private final ForumPostShareCashSingleCountMapper forumPostShareCashSingleCountMapper;
    private final SequenceCreater sequenceCreater;
    private final RedisSetAdapter redisSetAdapter;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final BizConfigProperties bizConfigProperties;
    private final MessageSender messageSender;
    private final DomainIntegrationService domainIntegrationService;
    private final H5JumpAddressProperties h5JumpAddressProperties;

    @Override
    public void handleReadData(HotPostReadDataDTO hotPostReadDataDTO) {
        ForumPostShareCashInfoEntity postShareCashInfoEntity = this.forumPostShareCashInfoMapper.getByPostId(hotPostReadDataDTO.getPostId());
        BigDecimal postAward = postShareCashInfoEntity.getAward();
        this.handleHotPostReadData(hotPostReadDataDTO, postAward);
    }

    @Override
    public void settlementHotPostCash() {
        String yesterdayStr = this.getYesterdaySimpleDateStr();
        String yesterdayNoRepeatStr = this.getYesterdayDateNoSeparatorStr();
        List forumPostShareCashCounterEntityList = this.forumPostShareCashCounterMapper.selectByAwardDate(yesterdayStr);
        for (ForumPostShareCashCounterEntity counterEntity : forumPostShareCashCounterEntityList) {
            if (counterEntity.getStatus() != 0) continue;
            EarningsSaveOrUpdateParam userEarningsParam = new EarningsSaveOrUpdateParam();
            userEarningsParam.setEarningsType(UserEarningsTypeEnum.SHARE_HOT_POST.getEarningsType());
            userEarningsParam.setEarningsTitle("\u5206\u4eab\u70ed\u6587\u5956\u52b1\u91d1");
            userEarningsParam.setOrderTime(new Date());
            userEarningsParam.setImg(this.bizConfigProperties.getPlatFromImgUrl());
            CashAccountParam param = new CashAccountParam();
            param.setExtData((Object)userEarningsParam);
            param.setAccountAction(AccountActionEnum.ADD_HOT_POST_SHARE_CASH);
            param.setCashFlowType(CashFlowTypeEnum.OTHER);
            param.setAmount(counterEntity.getAwardAmount());
            param.setUserId(counterEntity.getUserId());
            param.setRelationId(counterEntity.getId());
            param.setRemark("\u60a8\u7684\u5206\u4eab\u7684\u5e16\u5b50\u6628\u65e5\u83b7\u5f97\u5956\u52b1" + counterEntity.getAwardAmount().stripTrailingZeros().toPlainString() + "\u5143");
            boolean addDrawableCashResult = this.userAccountIntegrationService.cashAccountOperation(param);
            if (!addDrawableCashResult) continue;
            ForumPostShareCashCounterEntity updateCashCounterEntity = new ForumPostShareCashCounterEntity();
            updateCashCounterEntity.setId(counterEntity.getId());
            updateCashCounterEntity.setStatus(HotPostCashSettlementStatusEnum.SETTLEMENT.getCode());
            this.forumPostShareCashCounterMapper.updateByPrimaryKeySelective(updateCashCounterEntity);
        }
        this.redisSetAdapter.remove(this.buildJoinSharePostUserKey(yesterdayNoRepeatStr));
    }

    @Override
    public void pushSettlementMsg() {
        String yesterdayStr = this.getYesterdaySimpleDateStr();
        List settlementList = this.forumPostShareCashCounterMapper.selectByAwardDateAndSettlement(yesterdayStr);
        for (ForumPostShareCashCounterEntity counterEntity : settlementList) {
            this.executePushSettlement(counterEntity);
        }
    }

    private void executePushSettlement(ForumPostShareCashCounterEntity counterEntity) {
        String title = "\u5206\u4eab\u70ed\u6587\u5956\u52b1\u91d1\u5df2\u5230\u8d26";
        String content = String.format("\u60a8\u6628\u65e5\u5206\u4eab\u7684\u672c\u5730\u70ed\u6587\uff0c\u6709%s\u4eba\u9605\u8bfb\uff0c\u5e73\u53f0\u5956\u52b1%s\u5143\u5df2\u5230\u8d26\uff0c\u7ee7\u7eed\u5206\u4eab\u9886\u66f4\u591a\uff5e", counterEntity.getReadCount(), counterEntity.getAwardAmount().setScale(2, RoundingMode.HALF_DOWN));
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        String url = this.domainIntegrationService.getInnerH5BaseUrl() + String.format(this.h5JumpAddressProperties.getIncomePageUrl(), counterEntity.getUserId());
        String protocol = ProtocolFactory.appH5().url(url).build();
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.DEFAULT_SOUND);
        message.assign(counterEntity.getUserId());
        this.messageSender.sendPushMessage(message);
    }

    private void handleHotPostReadData(HotPostReadDataDTO readDataDTO, BigDecimal award) {
        HotPostShareContext shareContext = new HotPostShareContext();
        BeanUtils.copyProperties((Object)readDataDTO, (Object)shareContext);
        Message checkResult = this.hotPostCashFilterChain.handle(shareContext);
        if (Boolean.FALSE.equals(checkResult.isSuccess())) {
            log.warn("\u7528\u6237\u5956\u52b1\u6821\u9a8c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + checkResult.getLastMessage() + "\uff0c\u5e16\u5b50id\uff1a{}, \u7528\u6237id:{}", (Object)readDataDTO.getPostId(), (Object)readDataDTO.getShareUserId());
            return;
        }
        if (Boolean.FALSE.equals(this.redisStringAdapter.hasKey(this.buildPostAwardKey(readDataDTO.getPostId())))) {
            this.loadHotPostShareDb(readDataDTO.getPostId());
        }
        if (this.redisStringAdapter.decrement(this.buildPostAwardKey(readDataDTO.getPostId()), award.doubleValue()) >= 0.0) {
            int increaseResult = this.forumPostShareCashInfoMapper.increaseSendAward(readDataDTO.getPostId(), award);
            if (increaseResult > 0) {
                ForumPostShareCashRecordEntity newRecordEntity = this.createForumPostShareCashRecordEntity(shareContext, award);
                this.forumPostShareCashRecordMapper.insertSelective(newRecordEntity);
                if (Objects.isNull(this.forumPostShareCashSingleCountMapper.selectByUserIdAndPostId(readDataDTO.getShareUserId(), readDataDTO.getPostId()))) {
                    ForumPostShareCashSingleCountEntity newSingleCountEntity = new ForumPostShareCashSingleCountEntity();
                    newSingleCountEntity.setUserId(readDataDTO.getShareUserId());
                    newSingleCountEntity.setPostId(readDataDTO.getPostId());
                    newSingleCountEntity.setId(this.sequenceCreater.nextLongId());
                    this.forumPostShareCashSingleCountMapper.insertSelective(newSingleCountEntity);
                }
                this.forumPostShareCashSingleCountMapper.increaseReadCount(readDataDTO.getShareUserId(), readDataDTO.getPostId());
                this.forumPostShareCashSingleCountMapper.increaseAmount(readDataDTO.getShareUserId(), readDataDTO.getPostId(), award);
                String currentDayStr = this.getSimpleDateStr(readDataDTO.getReportDate());
                if (Objects.isNull(this.forumPostShareCashCounterMapper.selectByDateAndUserId(readDataDTO.getShareUserId(), currentDayStr))) {
                    ForumPostShareCashCounterEntity newCounterEntity = new ForumPostShareCashCounterEntity();
                    newCounterEntity.setUserId(readDataDTO.getShareUserId());
                    newCounterEntity.setAwardDate(currentDayStr);
                    newCounterEntity.setId(this.sequenceCreater.nextLongId());
                    this.forumPostShareCashCounterMapper.insertSelective(newCounterEntity);
                }
                this.forumPostShareCashCounterMapper.increaseTodayAwardAmount(readDataDTO.getShareUserId(), currentDayStr, award);
                this.forumPostShareCashCounterMapper.increaseTodayReadCount(readDataDTO.getShareUserId(), currentDayStr);
                BigDecimal remainAmount = (BigDecimal)this.redisStringAdapter.get(this.buildPostAwardKey(readDataDTO.getPostId()), BigDecimal.class);
                if (BigDecimal.ZERO.compareTo(remainAmount) >= 0) {
                    this.forumPostShareCashInfoMapper.offlineHotPost(readDataDTO.getPostId());
                }
            } else {
                log.error("\u70ed\u6587\u5e16\u5b50\u5956\u91d1\u5df2\u53d1\u91d1\u989d\u8d85\u8fc7\u6d3b\u52a8\u603b\u91d1\u989d\uff0c\u51fa\u73b0\u9519\u8bef\u60c5\u51b5\uff0c\u5e16\u5b50id\uff1a{}", (Object)readDataDTO.getPostId());
                this.forumPostShareCashInfoMapper.offlineHotPost(readDataDTO.getPostId());
            }
        } else {
            log.warn("\u5956\u91d1\u4e0d\u8db3\uff0c\u6263\u9664\u70ed\u6587\u5956\u91d1\u5931\u8d25\uff0c\u5e16\u5b50id\uff1a{}", (Object)readDataDTO.getPostId());
            this.redisStringAdapter.increment(this.buildPostAwardKey(readDataDTO.getPostId()), award.doubleValue());
            this.forumPostShareCashInfoMapper.offlineHotPost(readDataDTO.getPostId());
        }
    }

    private void loadHotPostShareDb(Long postId) {
        ForumPostShareCashInfoEntity shareCashInfoEntity = this.forumPostShareCashInfoMapper.getByPostId(postId);
        this.redisStringAdapter.set(this.buildPostAwardKey(postId), (Object)shareCashInfoEntity.getAmount().subtract(shareCashInfoEntity.getUsedAmount()));
    }

    private KeyGenerator buildJoinSharePostUserKey(String simpleDateStr) {
        return RedisConfig.TODAY_JOIN_SHARE_POST_USER_KEY.copy().appendKey((Object)simpleDateStr);
    }

    private String getSimpleDateStr(Date now) {
        return ((DateFormat)DateUtils.DATE_FORMAT_THREAD_LOCAL.get()).format(now);
    }

    private String getTodaySimpleDateStr() {
        return ((DateFormat)DateUtils.DATE_FORMAT_THREAD_LOCAL.get()).format(new Date());
    }

    private String getYesterdaySimpleDateStr() {
        Date yesterday = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
        return ((DateFormat)DateUtils.DATE_FORMAT_THREAD_LOCAL.get()).format(yesterday);
    }

    private String getTodayDateNoSeparatorStr() {
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
    }

    private String getYesterdayDateNoSeparatorStr() {
        Date yesterday = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(yesterday);
    }

    private ForumPostShareCashRecordEntity createForumPostShareCashRecordEntity(HotPostShareContext shareContext, BigDecimal award) {
        ForumPostShareCashRecordEntity newRecordEntity = new ForumPostShareCashRecordEntity();
        newRecordEntity.setUserId(shareContext.getShareUserId());
        newRecordEntity.setId(this.sequenceCreater.nextLongId());
        newRecordEntity.setCreateTime(new Date());
        newRecordEntity.setAward(award);
        newRecordEntity.setIp(shareContext.getIp());
        newRecordEntity.setId(this.sequenceCreater.nextLongId());
        newRecordEntity.setUserAgent(shareContext.getUserAgent());
        newRecordEntity.setPostId(shareContext.getPostId());
        newRecordEntity.setToken(shareContext.getOpenid());
        newRecordEntity.setStatus(HotPostShareRecordStatusEnum.NOT_SEND.getCode());
        return newRecordEntity;
    }

    private KeyGenerator buildPostAwardKey(Long postId) {
        return RedisConfig.SHARE_POST_AWARD_KEY.copy().appendKey((Object)postId);
    }

    public HotPostSettlementServiceImpl(HotPostCashFilterChain hotPostCashFilterChain, RedisStringAdapter redisStringAdapter, ForumPostShareCashRecordMapper forumPostShareCashRecordMapper, ForumPostShareCashInfoMapper forumPostShareCashInfoMapper, ForumPostShareCashCounterMapper forumPostShareCashCounterMapper, ForumPostShareCashSingleCountMapper forumPostShareCashSingleCountMapper, SequenceCreater sequenceCreater, RedisSetAdapter redisSetAdapter, UserAccountIntegrationService userAccountIntegrationService, BizConfigProperties bizConfigProperties, MessageSender messageSender, DomainIntegrationService domainIntegrationService, H5JumpAddressProperties h5JumpAddressProperties) {
        this.hotPostCashFilterChain = hotPostCashFilterChain;
        this.redisStringAdapter = redisStringAdapter;
        this.forumPostShareCashRecordMapper = forumPostShareCashRecordMapper;
        this.forumPostShareCashInfoMapper = forumPostShareCashInfoMapper;
        this.forumPostShareCashCounterMapper = forumPostShareCashCounterMapper;
        this.forumPostShareCashSingleCountMapper = forumPostShareCashSingleCountMapper;
        this.sequenceCreater = sequenceCreater;
        this.redisSetAdapter = redisSetAdapter;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.bizConfigProperties = bizConfigProperties;
        this.messageSender = messageSender;
        this.domainIntegrationService = domainIntegrationService;
        this.h5JumpAddressProperties = h5JumpAddressProperties;
    }
}

